Const GOM_title$ 		= "GOM shadow system"
Const GOM_otherAuthor$	= "Fredborg / Knorc"
Const GOM_development$  = "HautVent / Philippe C" 
Const GOM_test$			= "Bobysait/HautVent/Mangatone/Philippe C/Wako3d/Tmike/" 
Const GOM_version$ 		= "V01.00 dit boby"
;
;	This library manage the shadow effect
;
;----------------------------------------------------------------------------------------------
;to do :
;	attention aux objets non visibles .... du fait de leur centre sous la scene ....
;
;----------------------------------------------------------------------------------------------
;Version 01.00 :
;---------------
;
;- "rimplanter la lib sur un moteur entam signifie revoir toutes les implantations de mesh pour inclure 
; les prefixes "GOM_" et verifier les anomalies intrinseques propres au moteur"
;	ajout de 2 fonctions generiques qui evitent de declarer un certain nombre de les GOM_ sur les objets 3D
;	GOM_objectCreate and GOM_objectDelete
;
;- toutes les constantes commencent par GOM_ 
;- supprimer : GOM_api_cameraPosition$ => MoveEntity o\cameraShadow, 0,0,o\cameraDistance
;
;----------------------------------------------------------------------------------------------
;Version 00.53 :
;---------------
;- ajout de la fonction GOM_SahdowNO dans le but d'enliver le sombres parasites et eviter les calculs 
;	inutiles de projection d'ombres
;- ajouter demo 3 et 4
;
;----------------------------------------------------------------------------------------------
;Version 00.52 :
;---------------
;- premiere diffusion de la lib
;
;----------------------------------------------------------------------------------------------
;Version 00.51 :
;---------------
;- 	lors calcul quad la surface 1 est pris par defaut => 10 fps dans la cabanne
;  	rajout d'un parametre  la fonction createscene pour le parametrer
;- 	performance sur les ombres projettes : petit retour arrire : losque le centre de l'objet est en bas , il est
;	sous la scene donc la camera ne le voie pas .... 
;
;----------------------------------------------------------------------------------------------
;Version 00.50 :
;---------------
;- les ombres des colonnes ne s'affichent plus au plafond.  
;- amloiration des performances sur les ombres projettes
;
;----------------------------------------------------------------------------------------------
;Version 00.49 :
;---------------
;
;Bobysait :
;-"elle accroche qu'une seule entit  la fois . si je passe de la cabane au terrain, l'ombre 
; 	file sous la cabane"
;
;----------------------------------------------------------------------------------------------
;Version 00.48 :
;---------------
;Mangatone :
;-"pas d'ombre aux arbres anims." => OK
;
;----------------------------------------------------------------------------------------------
;Version 00.47 :
;---------------
;Mangatone :
;-"bug d'affichage sur l'image suivante" => non reproduit
;Bobysait :
;-"tu devrais eviter le rouge pour le texte , c'est pas trs lisible" => OK
;-"l'ombre devrait s'attenuer avec le soleil qui baisse  l'horizontal avant d'tre stopper directe 
;	quand la nuit tombe." => OK
;-"dernier point pour le moment : la nuit: la lumiere de Mak ne genere aucunes ombres pour les arbres". => OK
;
;- les ombres des colonnes ne s'affichent plus au plafond.   
;----------------------------------------------------------------------------------------------
;
;Version 00.41 :
;---------------
; Simplification de la gestion des ombres  
;
;----------------------------------------------------------------------------------------------
;
;Version 00.40 :
;---------------
;Nous pensons avoir franchi un pas significatif en terme de performances. + 10 FPS en moyenne 
;et surtout plus de timer ( la routine d'ombre ne s'executait que 10 fois pas seconde dans 
;la version precedente)
;
;Points corrigs :
;-wako3d :"robot tourne sur lui meme, meme  60 fps j'ai l'impression que a saccade" 
; => le systeme de camera est  amliorer"
;
;----------------------------------------------------------------------------------------------
;
;Version 00.39 :
;---------------
;Les amliorations portent sur la pixellisation et la qualit de l'ombre et + les perfs.
;
;Points corrigs :
;- bobysait : "pasque c'est assez pixelis"
;- bobysait : "comme si la mise  jour de l'ombre se faisait une boucle sur 10"
;
;----------------------------------------------------------------------------------------------
;Version 00.02  Version 00.38 : debuging
;----------------------------------------------------------------------------------------------
;Version 00.01 : initial version
;----------------------------------------------------------------------------------------------
Global debugg
Type GOM
	Field debug
	Field strict
End Type

Global gom.gom
gom.gom 	= New gom
gom\debug	= 0
gom\strict	= True


Const GOM_SUN			= 1		; the light type is a sun 
Const GOM_POINT			= 2		; the light type is a point 
Const GOM_SPOT			= 3		; the light type is a spot 

Const GOM_TEX_SIZE_QUAD	= 128	; size by default for the quad texture

Type GOM_camera
	Field idCamera				; blitz unique identifier of the camera
	Field idScene				; unique identifier of a scene	
	Field title$				; used to debug
	Field range					;
End Type

Type GOM_light
	
	Field ax#					; roatation x,y,z of the light
	Field ay#
	Field az#

	Field class$				; entityclass of the object
	Field colorUpdate 			; indicator to knoxw id teh color of the light has been updated
	Field idLight				; blitz unique identifier of the light
	Field idScene				; unique identifier of a scene

	Field lightheightMin		; this indicte the minimum height of the sun above the groud, by defualt it is the height at the creation
	Field lightmove				; indicator to know if a light is moving
	Field lightShadowMin			; indicate teh color minimum of a shadow
	
	Field lightType				; type of the light : SUN or POINT or SPOT	

	Field cr#					; red color
	Field cg#					; green color
	Field cb#					; blue color

	Field outer#				; in case of spot light only : outer angle
	
	Field px#					; position x,y,z of the light
	Field py#
	Field pz#
	
	Field range					; distance maximum of the light ray. Mandatory with POINT and SPOT
	Field title$				; used to debug
End Type

Type GOM_object
	Field animated				; true if the object is aniamted
	
	Field ax#					; rotation x,y,z of the object
	Field ay#
	Field az#	
	
	Field cameraShadow			; blitz unique identifier of the camera used for the shadow
	Field cameraDistance		; distance between the camera and the object
	Field camPlanDistance		; distance between the camera and the object in the plan x,z
	Field camZoom#				; zoom of the camera

;	Field checksumPos			; checksum position	
;	Field checksumRot			; checksum rotation
	Field class$				; entityclass of the object
	Field debugimage	
	
	Field file$					; file associated to the 3d model
	
	Field idScene				; unique identifier of a scene
	Field idObject				; blitz unique identifier
	Field idSurface				; Unique identifier in blitz of the surface
	Field idQuad				; the blitz identiifer of the quad
	Field textureSize#			; size on the texture
	Field idQuadTexture			; the blitz identifier of the texture for the quad
	Field idTextureOri			; kept the idQuadTexture in order to retore it after blank


	Field light.GOM_lIGHT		; handle of the light closer from the object

	Field mainScene				; if true it is the main scene
	Field mainSceneShadow 		; if true the main scene has a shadow
	Field numSurface			; in case of scene surface number to use.
	
	Field objectWidth#			; storage of the object size to avoid seach when it is needed
	Field objectDepth#			; 
	Field objectHeight#			; 	

	Field objectMove 			; indicator to know if the object can move or it is static
	Field objectType			; is it an actor ? MAIN_ACTOR, OTHER_ACTOR, STAGE , STAGE_ANIM

	Field parent%				; parent ofthe object is is used to know the position of the object

	Field px#					; position x,yz of the object
	Field py#
	Field pz#

	Field shadowDelay			; delay between 2 shadows computation in milli seconds
	Field shadowHeight			; if true indicate that the shadow appeare on the ceil => correction done : not very nice but ... 

	Field shadowMoveX#  		; position of the object and camera to do the shadow
	Field shadowMoveY# 			; this avoid that different object appeara on the shadow
	Field shadowMoveZ# 			; instead of one 

	Field shadowNO[10]			; the object in this list are ignored when projected shadow are computed
		
	Field shadowReceiver		; the object receives shadow : true/false
	Field shadowReceiverTexture ; texture of the receiver
	Field shadowReceiverCamera	; the camera used to do the shadow

;	Field shadowR				; shadow color red
;	Field shadowG				; shadow color green
;	Field shadowB				; shadow color blue
	
	Field shadowToDo			; indicate that a shadow has to be done for the light because object are visible
	
	Field surface[10]			; if the object of the scene support the shadow : surface to use in order to calculate the quad 
		
	Field sx#					; scale x,y,z of the object
	Field sy#
	Field sz#
		
	Field timer					; this timer is used to compute the shadow
	Field timerShadowed			; this timer is used to compute the shadow projection on object with shadow
	Field triangleMaxSize		; if the object of the scene support the shadow : maximum size of a triangle 
			
	Field title$				; use to debug

	Field volrange#				; storage of the maximum range of the object from the center
	Field vpOriginX				; wievport origin x of the camera
	Field vpOriginY				; wievport origin y of the camera
	Field vpSizeX				; wievport size x of the wievport 
	Field vpSizeY				; wievport size y of the wievport 

End Type

Type GOM_player
	Field camera.GOM_camera		; identifier of teh camera used in the game
	Field currentScene			; current scene where the player is
	Field idCamera				; unique blitz idzntifier of the camera of the game
	Field idPlayer				; unique identifier blitz use for the collision
	Field idLight				; use to do shadow
	Field message$				; debug message
	Field oldScene				; previous scene where the player was
	Field player.GOM_object		; identifier of the characreter player could be teh same than idPlayer
	Field textureWhite			; texture white used to blank the shadow 
	Field timerShadow			; tumer used to improve FPS
End Type

Type GOM_scene
	Field ambientLightr			; ambient light of the scene
	Field ambientLightg
	Field ambientLightb
	Field idScene				; unique identifier of a scene
	Field light.GOM_light		; point the light used
	Field scene.GOM_object		; point the first object
	Field vpOriginX 			; position of the last camera wievport
	Field vpOriginY	
End Type


Global gGOM_scene.GOM_scene
Global gGOM_player.GOM_player
Global gGOM_camera.GOM_camera

gGOM_player.GOM_player = New GOM_player

Dim vertrice(0,0)
Dim tvertX#(0,0)
Dim tvertZ#(0,0)

;GOM_sceneCreate()				;the scene 1 is created by default
;gGOM_player\currentScene = gGOM_scene\idScene


; honour to the workers !
If PUB Then 
	AppTitle GOM_Title + " " + GOM_Version
	Print
	Print "Concept Creator : " + GOM_otherAuthor
	Print
	Print "Developpement   : " + GOM_development 
	Print
	Print "test done by    : " 
	
	offset = Instr(GOM_test,"/",1)
	i = 1
	While offset
		a$ = Mid(GOM_test,i,(offset-i))
		Print "                  " + a$
		i = offset + 1
		offset = Instr(GOM_test,"/",i)
	Wend
	a$ = Mid(GOM_test,i)
	
	Print "                  " + a$
	Print
	Print "waiting for keyboard action ..."
	WaitKey()	
	Cls
	Locate 0,0
EndIf

;////////////////////////////////////////////////////////////////////////////////////////////
; 								PUBLIC FUNCTIONS
;////////////////////////////////////////////////////////////////////////////////////////////

Function GOM_________BLITZ__FUNCTION()
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	
End Function

Function GOM_animate(idObject,mode=1,speed#=1,sequence=0,transition#=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard anaimate function from blitz		
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idObject)
	
	If o\class = "mesh" Then Animate(idObject,mode,speed,sequence,transition)
	If o\class = "md2" 	Then AnimateMD2(idObject,mode,speed,sequence,transition)

	
	If mode <> 0 And speed <> 0 Then 
		GOM_api_objectSetAnim(idObject,True)
	Else
		GOM_api_objectSetAnim(idObject,False)
	EndIf
	

End Function

Function GOM_cameraRange(camera,min#,max#)
;--------------------------------------------------------------------------------------------
; this function store teh camera range , used for collision		
;--------------------------------------------------------------------------------------------

	CameraRange camera,min,max
	
	GOM_api_CameraSearch(camera)
	
	gGOM_camera\range = max
	
	
End Function


Function GOM_copyMesh(idObject,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = CopyMesh(idObject,parent)
	
	GOM_objectCreate("mesh_" + mesh ,mesh,parent,False)
	
	Return mesh

End Function

Function GOM_createCamera(parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	cam = CreateCamera(parent)
	
	GOM_api_CameraCreate(cam)
	
	Return cam

End Function

Function GOM_createCone(face=8,solid=True,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = CreateCone(face,solid,parent)
	
	GOM_objectCreate("cylinder_" + mesh ,mesh,parent,False)
	
	Return mesh

End Function

Function GOM_createCube(parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = CreateCube(parent)
	
	GOM_objectCreate("cube_" + mesh ,mesh,parent,False)
	
	Return mesh

End Function

Function GOM_createCylinder(face=8,solid=True,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = CreateCylinder(face,solid,parent)
	
	GOM_objectCreate("cylinder_" + mesh ,mesh,parent,False)
	
	Return mesh

End Function


Function GOM_createLight(lightType,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard create light function from blitz
; If a light is not needed the lighttype value should be negative		
;--------------------------------------------------------------------------------------------
		
	If lightType < 0 Then 
		idlight = CreatePivot(parent)
		GOM_api_lightCreate(idLight,lightType,"pivot")
	Else
		idlight = CreateLight(lightType,parent)
		GOM_api_lightCreate(idLight,lightType,"light")
	EndIf
	
	

	Return idLight
	
End Function

Function GOM_createMesh(parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = CreateMesh(parent)
	
	GOM_objectCreate("mesh_" + mesh ,mesh,parent,False)
	
	Return mesh

End Function

Function GOM_createSphere(face=8,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = CreateSphere(face,parent)
	
	GOM_objectCreate("sphere_" + mesh ,mesh,parent,False)
	
	Return mesh

End Function


Function GOM_freeEntity(entity)
;--------------------------------------------------------------------------------------------
; this function replace the standard freeentity function from blitz		
;--------------------------------------------------------------------------------------------

	FreeEntity(entity)	
	
	If GOM_objectDelete(entity)	Then Return True
	
	If GOM_api_lightDelete(entity) 	Then Return True
 
	If GOM_api_cameraDelete(entity)	Then Return True

End Function

Function GOM_lightColor(idlight,r#,g#,b#)
;--------------------------------------------------------------------------------------------
; this function replace the standard light color function from blitz		
;--------------------------------------------------------------------------------------------
	
	If GOM_api_LightColor(idlight,r,g,b) Then
		LightColor idlight,r,g,b
	EndIf	
	

End Function

Function GOM_lightConeAngles(idLight,inner#,outer#)
;--------------------------------------------------------------------------------------------
; this function replace the standard Light Cone Angles function from blitz		
;--------------------------------------------------------------------------------------------
	
	If GOM_api_LightConeAngles (idlight,outer) Then
		LightConeAngles idlight,inner,outer	
	EndIf
	
	

End Function


Function GOM_lightRange(idLight,range#)
;--------------------------------------------------------------------------------------------
; this function replace the standard light range function from blitz		
;--------------------------------------------------------------------------------------------
	
	If GOM_api_LightSetRange(idLight,range) Then
		LightRange idLight,range#
	EndIf
	
End Function

Function GOM_loadAnimMesh(file$,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = LoadAnimMesh(file,parent)
	
	GOM_objectCreate(file,mesh,parent)
	
	Return mesh

End Function


Function GOM_loadBSP(file$,gamma=0,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load anim mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = LoadBSP(file,gamma,parent)
	
	GOM_objectCreate(file,mesh,parent)
	
	Return mesh

End Function


Function GOM_loadMesh(file$,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load anim mesh function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = LoadMesh(file,parent)
	
	GOM_objectCreate(file,mesh,parent)
	
	Return mesh

End Function


Function GOM_loadMD2(file$,parent=0)
;--------------------------------------------------------------------------------------------
; this function replace the standard load md2 function from blitz		
;--------------------------------------------------------------------------------------------

	mesh = LoadMD2(file,parent)
	
	GOM_objectCreate(file,mesh,parent)
	
	Return mesh

End Function

Function GOM_MeshWidth#(idObject)
;--------------------------------------------------------------------------------------------
; this function replace the standard MeshWidth function from blitz		
;--------------------------------------------------------------------------------------------

	width# = GOM_api_MeshWidth(idObject)

	Return width

End Function

Function GOM_MeshHeight#(idObject)
;--------------------------------------------------------------------------------------------
; this function replace the standard MeshHeight function from blitz		
;--------------------------------------------------------------------------------------------

	Height# = GOM_api_MeshHeight(idObject)

	Return Height


End Function


Function GOM_MeshDepth#(idObject)
;--------------------------------------------------------------------------------------------
; this function replace the standard MeshDepth function from blitz		
;--------------------------------------------------------------------------------------------

	Depth# = GOM_api_MeshDepth(idObject)

	Return Depth


End Function


Function GOM_scaleEntity(idobject,sx#,sy#,sz#)
;--------------------------------------------------------------------------------------------
; this function replace the standard ScaleEntity  function from blitz		
;--------------------------------------------------------------------------------------------

	ScaleEntity idobject,sx,sy,sz
	
	GOM_api_scaleEntity(idobject,sx,sy,sz)
	
End Function

Function GOM_scaleMesh(idobject,sx#,sy#,sz#)
;--------------------------------------------------------------------------------------------
; this function replace the standard scaleMesh function from blitz				
;--------------------------------------------------------------------------------------------
	
	ScaleMesh idobject,sx,sy,sz
	
	GOM_api_scaleMesh(idobject,1,1,1)

End Function



Function GOM_________PUBLIC__FUNCTION()
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
End Function

Function GOM_lightHeigthMin(idlight,y)
;--------------------------------------------------------------------------------------------
; this function set the height minimum of the light , by default it is the y position of the 
; light		
;--------------------------------------------------------------------------------------------

	l.GOM_light = GOM_api_lightSearch(idLight)
	
	If l = Null Then Return
	
	l\lightheightMin	= y

End Function

Function GOM_lightShadowMin(idLight,light)
;--------------------------------------------------------------------------------------------
; This function set the minimum shadow color for the light, if light = 255 the shadow id balck
; if light = 0 the shadow is blank (no shadow). By default it is set to 200
;--------------------------------------------------------------------------------------------

	l.GOM_light = GOM_api_lightSearch(idLight)
	
	If l = Null Then Return
	
	l\lightShadowMin	= light

	
End Function

Function GOM_objectCreate(file$,idObject,parent,control=True,shadowDelay=150,textureSize=GOM_TEX_SIZE_QUAD)
;--------------------------------------------------------------------------------------------
; this function can be use instead of the function relative to teh 3D objetc creation			
;--------------------------------------------------------------------------------------------
	
	If FileType(file) <> 1 And control = True Then GOM_api_RuntimeError("GOM_api_objectCreate","the file does Not exist",file) : Return
		
	If idObject = 0 Then GOM_api_RuntimeError("GOM_objectCreate","objet number is mandatory",file,True) : Return 

	class$				= Lower(EntityClass(idObject))
		
	If class 	<> "mesh" And class 	<> "md2" Then 
		GOM_api_RuntimeError("GOM_objectCreate","this object is not supported by GOM system",file,True) : Return 
	EndIf
	
	o.GOM_object		= New GOM_object
	o\class				= class
	o\file				= file
	o\title				= GOM_api_getFile(file)
	o\idObject			= idObject
	
	If gGom_scene <> Null Then 	o\idScene = gGOM_scene\idScene
	
	If parent > 0 Then 
		o\parent		= parent
	Else
		o\parent		= o\idObject
	EndIf
	
	GOM_MeshWidth		(idObject)
	GOM_MeshDepth		(idObject)
	GOM_MeshHeight		(idObject)
	
	GOM_textureSize		(idObject,textureSize)
	GOM_shadowTime		(idobject,shadowDelay)
	
End Function

Function GOM_objectDelete(idObject)
;--------------------------------------------------------------------------------------------
; this function can be use instead of the function freentity to teh 3D objetc creation			
;--------------------------------------------------------------------------------------------

	Local o.GOM_object	
	del = False
	
	o.GOM_object 	= GOM_api_objectSearch(idObject)
	
	If o <> Null Then 
		Delete o
		Return True
	EndIf


	Return False

End Function


Function GOM_sceneCreate(objectid,r,g,b)
;--------------------------------------------------------------------------------------------
; this function create a scene with a 3D object. This is the ground			
;--------------------------------------------------------------------------------------------
	
	gGOM_scene					= Last GOM_scene
	idScene 					= 1
	If gGOM_scene <> Null 		Then idScene = gGOM_scene\idScene + 1

	gGOM_scene					= New GOM_scene
	
	gGOM_scene\idScene			= idScene
	 
	gGOM_scene\scene			= GOM_api_objectSearch(objectid)
	gGOM_scene\scene\mainScene 	= True
	gGOM_scene\scene\idScene	= idScene
	
	gGOM_scene\ambientLightr	= r
	gGOM_scene\ambientLightg	= g
	gGOM_scene\ambientLightb	= b
		
	
	AmbientLight 				r,g,b
	
			
End Function

Function GOM_sceneObjectAll(idobject)
;--------------------------------------------------------------------------------------------
; This function identify the object which belongs to several scene
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idobject)
	
	If o = Null Then GOM_api_runtimeerror("GOM_sceneObjectAll","The Object does Not exist",idObject) : Return 

	o\idScene = -1
	
End Function

Function GOM_sceneObjectSurface(idobject,surface)
;--------------------------------------------------------------------------------------------
; This function identify the surface to use in the object => improve performance
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idobject)
	
	If o = Null Then GOM_api_runtimeerror("GOM_sceneObjectSurface","The Object does Not exist",idObject) : Return 

	i = 0
	DebugLog o\surface[i] + "-"
	While o\surface[i] > 0 And i < 10
		i = i + 1
	Wend
	
	If i > 10 Then GOM_api_runtimeerror("GOM_sceneObjectSurface","too much surfaces",idObject,True) 
	
	o\surface[i]= surface
	
End Function


Function GOM_scenePrepare(idScene,debug=False,x=0,y=-10000,z=0,dist=100)
;--------------------------------------------------------------------------------------------
; this function prepare the scene in order to optimise the shadow computation
; verifier le camera range => erreur si pas connu
; x,y,z,dist
; 	variables used to calculate the location of the shadow picture
; 	the object to shadow is moved in empty place in order to take a picture
; 	of this object only
;--------------------------------------------------------------------------------------------
	Local error$
	
	If idscene <= 0 Then 
		GOM_api_RuntimeError ("GOM_scenePrepare","Set the start scene = ", idScene,True)
	EndIf
	
	idScene = GOM_api_sceneSearch(idScene)

	; init a texture in order to blank the quad when no shadow are done
	gGOM_player\textureWhite = LoadTexture("media\white.bmp")
	TextureCoords gGOM_player\textureWhite,1

	saveIdscene = idScene

	idScene = -1		
	
	;GOM_api_sceneControl()
	
	
	For l.GOM_light	= Each GOM_light
		If l\LightheightMin = 0 Then l\LightheightMin = EntityY(l\idLight)
	Next
	
	For o.GOM_object = Each GOM_object 	
		
		o\volrange		=  o\objectHeight

		If o\objectwidth	> o\objectDepth Then 
			o\volrange = o\volrange + o\objectwidth
		Else
			o\volrange = o\volrange + o\objectDepth
		EndIf

		If  o\mainScene = False
							
			error = GOM_api_lightClosed(o)
			If Len(error) > 0 Then GOM_api_RuntimeError ("GOM_scenePrepare1",error,o\title)
			
		
			GOM_api_cameraShadow(o)
				
			error = GOM_api_cameraPosition(o)
		
			If Len(error) > 0 Then GOM_api_RuntimeError ("GOM_scenePrepare2",error,o\title)

			; position of Object in order To do the shadow
			x = x + dist
			z = z + dist
			
			o\shadowMoveX = x 
			o\shadowMoveY = y
			o\shadowMoveZ = z
		EndIf	
		
		; init the position of the object
		GOM_api_objectIsMoving(o,False)

		If o\class = "mesh" And o\animated = False And AnimLength(o\idObject) <= 0
			ScaleEntity	o\idObject,1,1,1	
			ScaleMesh o\idObject,o\sx,o\sy,o\sz
			o\sx = 1
			o\sy = 1
			o\sz = 1
			RotateEntity o\idObject,0,0,0
			RotateMesh o\idObject,o\ax,o\ay,o\az
			o\ax = 0
			o\ay = 0
			o\az = 0
		EndIf
		If o\surface[0]	<= 0 Then o\surface[0] = 1
		o\objectMove = -1		
	Next
	 
	For gGOM_scene = Each GOM_scene
	
		mainScene = False
		
		If gGOM_scene\scene <> Null Then 
			GOM_api_sceneTriangle()
			mainScene = True
		EndIf	
	
		If Not mainScene Then GOM_api_RuntimeError ("GOM_scenePrepare","There is no main scene in scene = ", gGOM_scene\idScene)
	Next
	
	
	GOM_api_sceneSearch(saveIdscene)
	If gGOM_scene = Null Then GOM_api_RuntimeError ("GOM_scenePrepare","The start scene does not exist= ", saveIdscene ,True)
	

End Function


Function GOM_sceneShadow(collision,joueur,camera,debug=0)
;--------------------------------------------------------------------------------------------
; this function compute the shadow 			
;--------------------------------------------------------------------------------------------
	
If KeyHit(64) = 1 Then	debugg = True : Stop; F6
If KeyHit(65) = 1 Then	debugg = False ;  Stop; F7

	If gGOM_player\Player <> Null Then 
		If gGOM_player\Player\idObject	<> joueur 
			gGOM_player\Player 	= GOM_api_objectSearch(joueur)
		EndIf
		gGOM_player\idPlayer 	= collision
	Else
		gGOM_player\Player 		= GOM_api_objectSearch(joueur)
		gGOM_player\idPlayer 	= collision
	EndIf

	If gGOM_player\camera <> Null Then 
		If gGOM_player\camera\idcamera 	<> camera 
			gGOM_player\camera 	= GOM_api_CameraSearch(camera)
			gGOM_player\Idcamera= camera
		EndIf
	Else
		gGOM_player\camera 		= GOM_api_CameraSearch(camera)
		gGOM_player\Idcamera	= camera
	EndIf
	
	If GOM_api_objectInViewCamera(debug) Then 

		CameraProjMode camera,0																; 10 FPS and more save by this commands	
		RenderWorld 	
	
		gGOM_player\message = TrisRendered()
		CameraProjMode camera,1																; 10 FPS and more save by this commands
	EndIf
	
	
	GOM_api_captureTextureScene(gGOM_player\Idcamera,debug)
	
	
End Function

Function GOM_sceneTitle(idObject,title$="")
;--------------------------------------------------------------------------------------------
; this function should be used if the GOM_blitz in order to name the object abd facilitate debug 
;--------------------------------------------------------------------------------------------

	class$ = Lower(EntityClass(idobject))
	
	Select class
		Case 	"mesh"
			GOM_api_objectTitle(idObject,title)
		Case 	"md2"
			GOM_api_objectTitle(idObject,title)
		Case 	"bsp"
			GOM_api_objectTitle(idObject,title)
		Case 	"camera"
			GOM_api_cameraTitle(idObject,title)
		Case 	"light"
			GOM_api_lightTitle(idObject,title)
		Default
			GOM_api_runtimeerror("GOM_sceneTitle","Object Not supported by this Function used the speficic one" ,class) : Return 
	End Select
	
	
End Function

Function GOM_shadowHeight(idobject,y)
;--------------------------------------------------------------------------------------------
; This function set the height of the shadow in order to avoid parasite sahdow on the ceil
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idobject)
	
	If o = Null Then GOM_api_runtimeerror("GOM_textureSize","The Object does Not exist",idObject) : Return 

	o\shadowHeight = y
	
End Function

Function GOM_shadowNO(idObject1,idObject2)
;--------------------------------------------------------------------------------------------
; This function store the fact that object1 don't project shadow on object2 =
;	improve performance
;	avoid parasite shadow
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idobject1)
	
	i = 0
	While o\shadowNo[i] <> 0 And i < 10 
		i = i + 1
	Wend
	
	If i > 10  Then GOM_api_runtimeerror("GOM_shadowNO","Too manny no shadowed object (limit is 10) , the object is ignored",idObject1 + " " + o\title) : Return 

	o\shadowNo[i]	= idObject2
	
End Function


Function GOM_shadowTime(idobject,time)
;--------------------------------------------------------------------------------------------
; This function set the height of the shadow in order to avoid parasite sahdow on the ceil
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idobject)
	
	If o = Null Then GOM_api_runtimeerror("GOM_textureSize","The Object does Not exist",idObject) : Return 

	o\shadowDelay = time
	
End Function


Function GOM_textureSize(idobject,size)
;--------------------------------------------------------------------------------------------
; This function identify the object which belongs to several scene
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idobject)
	
	If o = Null Then GOM_api_runtimeerror("GOM_textureSize","The Object does Not exist",idObject) : Return 

	o\textureSize = size
	
End Function

Function GOM_zoomSize(idobject,size#)
;--------------------------------------------------------------------------------------------
; This function identify the object which belongs to several scene
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idobject)
	
	If o = Null Then GOM_api_runtimeerror("GOM_zoomSize","The Object does Not exist",idObject) : Return 

	o\camZoom = size
	
End Function


Function GOM_________API__Shadow()
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	
End Function

Function GOM_api_objectInViewCamera(debug)
;--------------------------------------------------------------------------------------------
; this function identify the objet in the game camera viewport		
;--------------------------------------------------------------------------------------------
	Local error$
	
	If debugg Then DebugLog "objectInViewCamera------"

	camera			= gGOM_player\idCamera
	idScene 		= 0
	lightMove		= 0
	noView 			= False
	
	;gGOM_player\message = "" ; debug
	
	For o.GOM_object = Each GOM_object
	
		o\shadowToDo 	= False 
		If o\timer < MilliSecs() Then 
			o\timer = o\shadowDelay + MilliSecs()
			
			If o\mainScene = False Then
				
				If GOM_api_entityInView(camera,o\idObject,o\idQuad,o\volRange)
												 
																					
					
					lightMove = GOM_api_lightIsMoving(o\light) 
					
					If lightmove < 0 Then 														; if light associated to the object is switch off
						If o\idQuad > 0 Then FreeEntity o\idQuad : o\idQuad = 0					; the quad is deleted ( the shadow diseappears)
					EndIf
					
					GOM_api_objectIsMoving(o,lightMove)
							
					If o\objectMove 	> 0 Or o\idQuad = 0 Then
					
						If o\objectMove = 2 Then 
							FreeEntity o\idQuad : o\idQuad = 0 			; if the position of the quad change
							If o\idObject = gGOM_player\player\idObject Then 
								GOM_api_sceneWhereIsPlayer()
								; reinit the projected shadow in order to avoid double shadow when the scene change
								For oo.GOM_object = Each GOM_object
									If oo\shadowReceiverCamera	= o\cameraShadow Then 
										oo\timerShadowed 		= 0
										oo\shadowReceiverCamera = 0
									EndIf
								Next 
							EndIf
						EndIf
						
						error 			= GOM_api_lightClosed(o) 
						If Len(error) 	<= 0 Then 
							
							GOM_api_cameraPosition(o) 
							
							If o\idQuad = 0 Then GOM_api_quad(o,debug) : If debugg Then DebugLog o\title
							If o\idQuad = 0 Then 
								GOM_api_runtimeError("GOM_api_objectInViewCamera", "quad to do the shadow not generated",o\title)
							Else
								o\shadowToDo 	= True
								
								noView 			= True
							EndIf
		
						Else
							If o\idQuad > 0 Then FreeEntity o\idQuad : o\idQuad = 0 
						EndIf
					EndIf
				Else
					If o\idQuad > 0 Then FreeEntity o\idQuad : o\idQuad = 0 
				EndIf
			EndIf
		EndIf	
	Next
	
	; done separatly when a light  is linked to a character => the light is too far
	For o.GOM_object = Each GOM_object
		If o\shadowToDo Then GOM_api_cameraShadowShow(o,camera)
	Next	
	
	; switch off the light in order to get a correct shadow
	For l.GOM_light = Each GOM_light
		LightColor l\idLight,0,0,0
	Next 
	
	Return noView 
	
End Function

Function GOM_api_cameraPosition$(o.GOM_object)
;--------------------------------------------------------------------------------------------
; this function put in position the shadow camera. 
;--------------------------------------------------------------------------------------------

	If o\cameraDistance <= 0 	Then Return "- the camera distance should be set for : " 	+ o\title + Chr(10)
	If o\cameraShadow   <= 0 	Then Return "- the camera shadow should be set for : " 		+ o\title + Chr(10)
	If o\light			= Null 	Then Return "- no light associated to this object  : " 		+ o\title + Chr(10)
	
	If o\light\lightType = GOM_SUN Then 
		
		;in case of sun the light is always at the same position whatever the position of the object
		x#				= EntityX(o\idObject,True)
		y# 				= EntityY(o\idObject,True)
		z#				= EntityZ(o\idObject,True)

		PositionEntity 	o\idObject		,0,0,0
		PositionEntity 	o\cameraShadow	,0,0,0
		PointEntity 	o\cameraShadow	,o\light\idLight
		MoveEntity 		o\cameraShadow	,0,0,o\cameraDistance

		; whatever the object position the shadow is the same except if the sun move		
		PositionEntity 	o\idObject		,x,y,z,True
		PositionEntity 	o\cameraShadow	,EntityX(o\cameraShadow,True)+x,EntityY(o\cameraShadow,True)+y,EntityZ(o\cameraShadow,True)+z,True

	Else
		; in case of light the camera is positionned on the "axe" between the object and the light 
		; And the camera is at a predefine distance of the object
		
		PositionEntity 	o\cameraShadow, o\px, o\py, o\pz
		PointEntity 	o\cameraShadow, o\light\idLight
		MoveEntity 		o\cameraShadow, 0,0,o\cameraDistance
		
		If EntityY(o\cameraShadow,True) <  o\py Then 
			PositionEntity o\cameraShadow,EntityX(o\cameraShadow,True),o\py * o\py/4.0 ,EntityZ(o\cameraShadow,True)
		EndIf
				
	EndIf
		
	
	PointEntity o\cameraShadow, o\parent
	
	
End Function

Function GOM_api_cameraShadowHide(o.GOM_object,cameraScene)
;--------------------------------------------------------------------------------------------
; this function hide the camera shadow viewport and show the hidded object
;--------------------------------------------------------------------------------------------
	
	
	If o\shadowToDo	= True  Then 

		If GetParent(cameraScene) = o\idObject Then 
			xc# =  EntityX(cameraScene,True)
			yc# =  EntityY(cameraScene,True)
			zc# =  EntityZ(cameraScene,True)
		EndIf

		x# = EntityX(o\idobject,True)- o\shadowMoveX
		y# = EntityY(o\idobject,True)+ o\shadowMovey
		z# = EntityZ(o\idobject,True)- o\shadowMovez
		PositionEntity o\idobject,x,y,z,True
		
		x# = EntityX(o\cameraShadow,True)- o\shadowMoveX
		y# = EntityY(o\cameraShadow,True)+ o\shadowMovey
		z# = EntityZ(o\cameraShadow,True)- o\shadowMovez
		PositionEntity o\cameraShadow,x,y,z,True
		
		
		; if the camera scene is the child of an object , the camera is repositionned 
		; in order to get the same view
		If GetParent(cameraScene) = o\idObject Then 
			PositionEntity cameraScene,xc,yc,zc,True
		EndIf
	EndIf
			
	
End Function

Function GOM_api_cameraShadowShow(o.GOM_object,cameraScene)
;--------------------------------------------------------------------------------------------
; this function show the camera shadow viewport and hide the receiver objects
;--------------------------------------------------------------------------------------------
	
	If o\shadowToDo	= True  Then 

		CameraProjMode 	o\cameraShadow,2
		;gGOM_player\message	= gGOM_player\message + o\title + " , "
		
		If GetParent(cameraScene) = o\idObject Then 
			xc# =  EntityX(cameraScene,True)
			yc# =  EntityY(cameraScene,True)
			zc# =  EntityZ(cameraScene,True)
		EndIf

		x# = EntityX(o\idobject,True)+ o\shadowMoveX
		y# = EntityY(o\idobject,True)- o\shadowMovey
		z# = EntityZ(o\idobject,True)+ o\shadowMovez
		PositionEntity o\idobject,x,y,z,True
		
		x# = EntityX(o\cameraShadow,True)+ o\shadowMoveX
		y# = EntityY(o\cameraShadow,True)- o\shadowMovey
		z# = EntityZ(o\cameraShadow,True)+ o\shadowMovez
		PositionEntity o\cameraShadow,x,y,z,True	
		
		; compute the shadow fading
		l = o\light\cr
		If l < o\light\cg Then l = o\light\cg
		If l < o\light\cb Then l = o\light\cb
		If l > o\light\lightShadowMin Then l = o\light\lightShadowMin
		 
		CameraFogColor 	o\cameraShadow, 255-l,255-l,255-l
		
		; if the camera scene is the child of an object , the camera is repositionned 
		; in order to get the same view
		If GetParent(cameraScene) = o\idObject Then 			
			PositionEntity cameraScene,xc,yc,zc,True
		EndIf
		
	EndIf
	

		
End Function


Function GOM_api_captureTextureScene(cameraScene,debug) ;idScene,
;--------------------------------------------------------------------------------------------
; this function captur ethe shadow texture
;--------------------------------------------------------------------------------------------



	For o.GOM_object = Each GOM_object 

		If o\shadowToDo = True  Then 
			
			If o\idQuadTexture = 0 Then RuntimeError "GOM_api_captureTextureScene o\idQuadTexture does not exist" 
								
			CopyRect o\vpOriginX,o\vpOriginY,o\vpSizeX,o\vpSizeY,0,0,BackBuffer(),TextureBuffer(o\idQuadTexture)	

			; to avoid infinite shadow put a white square around the texture
			SetBuffer TextureBuffer(o\idQuadTexture) 
			Color 255,255,255 
			Rect 0, 0, o\vpSizeX,o\vpSizeY, False 
			SetBuffer BackBuffer() 
			
			
			GOM_api_cameraShadowHide(o,cameraScene);perf
			 
			GOM_api_quadUV(o) 
		
		EndIf


	Next
	
	; switch on  the light in order to get a correct shadow
	;If o\light <> Null Then LightColor o\light\idLight,o\light\r,o\light\g,o\light\b
	For l.GOM_light = Each GOM_light
	;If o\light <> Null Then LightColor o\light\idLight,0,0,0
		LightColor l\idLight,l\cr,l\cg,l\cb
	Next 

	If debugg Then DebugLog "captureTextureScene----------------------------------------"
	; the receiver should be calculated when everything is in place 
	For o.GOM_object = Each GOM_object 
		If o\timerShadowed < MilliSecs() Then
			o\timerShadowed = 0
			GOM_api_receiverTexture(o.GOM_Object,cameraScene) 
			If  o\timerShadowed = 0 Then o\timerShadowed = o\shadowDelay + MilliSecs()
		EndIf
	Next

	; set the shadow and light indicator to 0 in order to check the difference next loop
	For o.GOM_object = Each GOM_object 
		
		If o\light <> Null Then 
			o\light\lightMove	= False
		EndIf
		
		If o\cameraShadow > 0 
			If o\shadowToDo Then 
				If debug
					CameraProjMode o\cameraShadow,2
				Else
					CameraProjMode o\cameraShadow,0
				EndIf
			EndIf
			If Not debug Then CameraProjMode o\cameraShadow,0
		EndIf
		
		o\shadowToDo	= False
		
	Next
	


End Function

Function GOM_api_EntityDistance#(o1,o2)
;--------------------------------------------------------------------------------------------
; to compute the xz distance without take into account the y		
;--------------------------------------------------------------------------------------------
	
	x# 	= (EntityX(o1,True)-EntityX(o2,True))
	x	= x * x

	y# 	= (EntityY(o1,True)-EntityY(o2,True))
	y	= y * y
	
	z# 	= (EntityZ(o1,True)-EntityZ(o2,True))
	z	= z * z
 
	r# 	= x + z + y
	r 	= Sqr(r)
	
	Return r


End Function

Function GOM_api_quad(o.GOM_Object,debug)
;--------------------------------------------------------------------------------------------
; to compute the quad surface ; the vertex closed from the object are serached
; and copied into the quad			
;--------------------------------------------------------------------------------------------

	If o\light 		= Null 					Then Return
	If o\objectMove <> 2 And o\idQuad > 0 	Then Return
	
	Local GOM_scene.GOM_scene
	
	If o\idScene <> -1 Then 
		If o\idScene <> gGOM_scene\idScene
			For GOM_scene = Each gom_scene
				If o\idScene = GOM_scene\idScene Then Exit
			Next
		Else
			GOM_scene = gGOM_scene
		EndIf
	Else
		GOM_scene = gGOM_scene
	EndIf

	If GOM_scene = Null Then GOM_api_runtimeError("GOM_api_quad","unknown scene",scene,True)
	
	scene 		= GOM_scene\scene\idobject
	sx#			= GOM_scene\scene\sx
	sy#			= GOM_scene\scene\sy
	sz#			= GOM_scene\scene\sz
	triMax		= GOM_scene\scene\triangleMaxSize
	
	px#			= GOM_scene\scene\px
	py#			= GOM_scene\scene\py
	pz#			= GOM_scene\scene\pz
	numSurface	= GOM_scene\scene\numSurface


	;xcam# 		= EntityX(gGOM_player\Idcamera,True)
	;ycam# 		= EntityY(gGOM_player\Idcamera,True)
	;zcam# 		= EntityZ(gGOM_player\Idcamera,True)

	
	If o\idQuadTexture 	<= 0 Then 
		o\idQuadTexture = CreateTexture(o\textureSize, o\textureSize,1+16+32+256)
		TextureCoords 	o\idQuadTexture, 1
		TextureBlend 	o\idQuadTexture, 2
		o\idTextureOri	= o\idQuadTexture
		;o\debugImage	= CreateImage(o\textureSize, o\textureSize)
	EndIf
	o\idQuadTexture = o\idTextureOri
	
	If o\idQuad 		> 0 Then FreeEntity o\idQuad : o\idQuad = 0 
	
	o\idQuad 	= CreateMesh()
	quadSurface = CreateSurface(o\idQuad)
	
		
	; calcul temporaire du rayon maxi du quad
	dist		= GOM_api_quadRadius(o.GOM_Object,triMax)
	dist 		= dist*dist
	
	ox#			= o\px - px
	oz#			= o\pz - pz
	
	; y max of the quad height
	ymax#		= o\py ; the ceneter of the object is in teh midle
	
	k = 0
	While GOM_scene\scene\surface[k] > 0 
	
		surf 		= GetSurface(scene ,GOM_scene\scene\surface[k])
		tris		= (CountTriangles(surf)-1)
		
		; search for the vertex closed form the object
		ve = CountVertices(surf)
		Dim vertrice(CountVertices(surf),1)
		
		For i = 0 To tris
			For j = 0 To 2
				 
				v = TriangleVertex(surf,i,j)
				
				x# = VertexX(surf,v) * sx
				y# = VertexY(surf,v) * sy
				z# = VertexZ(surf,v) * sz
							
				If y <  ymax											; avoid in cubing zone shadow to get a cubic quad
					d#	= (x-ox)*(x-ox) + (z-oz)*(z-oz) 				; avoid root squared computation
					If d <= dist Then 
	
						GOM_api_quadCreateTris(quadSurface ,surf,i,sx,sy,sz);xcam,ycam,zcam)
						Exit
		
					EndIf

				EndIf
			Next	
		Next
		Dim vertrice(0,0)
		k = k + 1
	Wend
	
	PositionEntity 		o\idQuad,px,py,pz 
	EntityTexture 		o\idQuad,o\idQuadTexture,0,1
	If debug
		EntityColor 		o\idQuad,Rnd(100,255),Rnd(100,255),Rnd(100,255)
	Else
		EntityBlend 		o\idQuad,2
	EndIf
	
	EntityFX 			o\idQuad,1+8+16
	
	;DebugLog "GOM_api_quad "+ o\title + "=" + CountTriangles(GetSurface(o\idQuad,1))

	
End Function

Function GOM_api_quadCreateTris(quadSurface ,surf,i,sx#,sy#,sz#);xcam#,ycam#,zcam#)
;--------------------------------------------------------------------------------------------
; this function create each vertex one time ( the array vertrice indicate if the vertex 
; has been cerated)
; The scale of the scene is taken into account when scaleentity has been used.
; The quad is posstionning under the the scene in the direction of the camera in order
; to avoid that the quad is hidden by the scene : it should be above the scene.
; 	X & Z of teh quad should be also above the scene when the scene is vertical.
;--------------------------------------------------------------------------------------------

	;ep#	= 0
	v0 = TriangleVertex(surf,i,0)
	If vertrice(v0,1) = 0 ; create the vertex only one time
		x# = VertexX(surf,v0)*sx 
		y# = VertexY(surf,v0)*sy
		z# = VertexZ(surf,v0)*sz
		
		; position of the quad in the direction of the camera 
		; in order To avoid that the quad is hiden by the scene
		;If x < xcam Then x = x + ep Else x = x - ep 
		;If y < ycam Then y = y + ep Else y = y - ep
		;If z < zcam Then z = z + ep Else z = z - ep
		
		vertrice(v0,0) = AddVertex(quadSurface ,x,y,z) ; store the new vertex number
		vertrice(v0,1) = 1 ; create the vertex only one time
	EndIf
	
	v1  = TriangleVertex(surf,i,1)
	If vertrice(v1,1) = 0
		x# = VertexX(surf,v1)*sx 
		y# = VertexY(surf,v1)*sy 
		z# = VertexZ(surf,v1)*sz
		 
		; position of the quad in the direction of the camera 
		; in order To avoid that the quad is hiden by the scene
		;If x < xcam Then x = x + ep Else x = x - ep 
		;If y < ycam Then y = y + ep Else y = y - ep
		;If z < zcam Then z = z + ep Else z = z - ep
		
		vertrice(v1,0) = AddVertex(quadSurface ,x,y,z)
		vertrice(v1,1) = 1
	EndIf
	
	v2 = TriangleVertex(surf,i,2)	
	If vertrice(v2,1) = 0
		x# = VertexX(surf,v2)*sx 
		y# = VertexY(surf,v2)*sy 
		z# = VertexZ(surf,v2)*sz 
		
		; position of the quad in the direction of the camera 
		; in order To avoid that the quad is hiden by the scene
		;If x < xcam Then x = x + ep Else x = x - ep 
		;If y < ycam Then y = y + ep Else y = y - ep
		;If z < zcam Then z = z + ep Else z = z - ep
		
		vertrice(v2,0) = AddVertex(quadSurface ,x,y,z)
		vertrice(v2,1) = 1
	EndIf

	; use the new vertex value to create the triangle
	AddTriangle quadSurface ,vertrice(v0,0),vertrice(v1,0),vertrice(v2,0)

End Function

Function GOM_api_quadRadius(o.GOM_Object,triMax)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	lighty#	   	= o\light\py
	hypo#		= EntityDistance(o\light\idLight,o\idObject)
	heightMin# 	= o\volRange
	
	If lighty 	<  heightMin Then heightMin = lightY + 1
	
	oppSide#	= lighty - heightMin

	angle 		= ASin(oppSide/hypo)
	
	radius		= (o\volRange/1.5)* Cos(angle) ; (oppSide/hypo) + o\volRange  ;Sin(angle)
	radius		= radius;/3
	If radius 	< triMax Then radius = trimax
	
	Return radius

End Function

Function GOM_api_quadUV(o.GOM_object)
;--------------------------------------------------------------------------------------------
; this function computes the UV coordinate of the quad in order to get a correct shadow			
;--------------------------------------------------------------------------------------------


	If o\idQuadTexture <> 0 Then

		surf  	= GetSurface(o\idQuad, 1)
		cv% 	= CountVertices(surf)
		
		ymax = o\py + o\shadowHeight
		
		For v=0 To cv-1
			
			
			TFormPoint 		VertexX(surf, v), VertexY(surf, v), VertexZ(surf, v), o\idQuad, 0
			x# 				= TFormedX()
			y# 				= TFormedY()
			z# 				= TFormedZ()
			
	 		
			CameraProject 	o\cameraShadow,x,y,z	
			
			
			tu# 			= ProjectedX()/o\textureSize
			tv# 			= ProjectedY()/o\textureSize

			If y > ymax Then 
				VertexTexCoords surf, v, 65535, 65535, 0, 1
			Else
				VertexTexCoords surf, v, Tu, Tv, 0, 1
			EndIf
		Next
	EndIf

End Function

Function GOM_api_lightCheckAngle(idObject,idLight,outer)
;--------------------------------------------------------------------------------------------
; this function checks if the object is in the cone of the spot in function of light angle
; and the outer angle of the spot
;--------------------------------------------------------------------------------------------

	
	Return True
	
End Function

Function GOM_api_lightClosed$(o.GOM_Object)
;--------------------------------------------------------------------------------------------
; this function search for the light which is closer from the object
; and compute , check the camera distance with the light 
;--------------------------------------------------------------------------------------------
	
	Local error$
	
	distance 		= 999999
		
	o\light			= Null
	
	If o\mainScene = True And o\mainSceneShadow = False Then Return "- No shadow to compute : " + o\title + Chr(10)
	
	For l.GOM_light = Each GOM_light

		lightSwitchOn = l\cr + l\cg + l\cb
		If lightSwitchOn Then

			If EntityVisible(o\parent,l\idLight) Then 
				If l\lightType <> GOM_SUN Then 
					;DebugLog "light= " + EntityX(l\idLight,True) + " " + EntityY(l\idLight,True) + " " +EntityZ(l\idLight,True) 
					;DebugLog "objet= " + EntityX(o\idObject,True)+ " " + EntityY(o\idObject,True)+ " " +EntityZ(o\idObject,True) 
					
					d = GOM_api_EntityDistance(l\idLight,o\idObject) 
					If d < distance Then
						If d <= l\range ; if the object is not too far from the light
							If l\lightType = GOM_POINT Then 
								If o\light <> Null Then 
									error = error + "- The static object is closed from more than 1 light : " + o\title + Chr(10)
								EndIf
								distance  	= d
								o\light		= l
							EndIf
							If l\lightType = GOM_SPOT Then 
								If GOM_api_lightCheckAngle(o\idObject,l\idLight,l\outer)
									If o\light <> Null Then 
										error = error + "- The static object is closed from more than 1 light : " + o\title + Chr(10)
									EndIf
									distance  	= d
									o\light		= l
								EndIf
							EndIf
							
						EndIf
					EndIf
				Else
					; the sun is visible from everywhere and computed only one time	
					o\light 		= l
					o\cameraDistance= EntityDistance(l\idLight,o\idObject)/2 			
					distance  		= o\cameraDistance 
					Exit
				EndIf
			EndIf
		EndIf
	Next
	
	
	If o\light = Null Then 
		o\cameraDistance	= 999999
		error = error + "- The object is too faraway from a light or the scene's lights are without color : " + o\title + Chr(10)
	Else
		o\camPlanDistance	= GOM_api_planDistance(o\idObject,o\light\idLight)
		o\cameraDistance	= distance  
	EndIf
	
	Return error

End Function

Function GOM_api_lightIsMoving(l.GOM_light)
;--------------------------------------------------------------------------------------------
; this function check if the lights are moving			
;--------------------------------------------------------------------------------------------
		
		
	If l = Null Then Return False
	
	If l\lightMove Then Return l\lightMove
	
	l\lightMove	= False
	
	col = l\cr + l\cg + l\cb 
	
	If  col > 0 Then 												; is the light activated
	
		lpx#			= l\px
		lpy#			= l\py
		lpz#			= l\pz
		lax#			= l\ax
		lay#			= l\ay
		laz#			= l\az
	
		l\px			= EntityX(l\idlight,True)
		l\py			= EntityY(l\idlight,True)
		l\pz			= EntityZ(l\idlight,True)	
		l\ax			= EntityPitch(l\idlight,True)
		l\ay			= EntityYaw	 (l\idlight,True)
		l\az			= EntityRoll (l\idlight,True)
		
		px#				= l\px
		py#				= l\py
		pz#				= l\pz
	
		If 	px <> lpx Then
			l\lightMove	= True
		ElseIf 	py <> lpy Then
			l\lightMove	= True
		ElseIf 	pz <> lpz Then
			l\lightMove	= True

		EndIf 		
		
		ax#				= l\ax
		ay#				= l\ay
		az#				= l\az
				
		If 	ax <> lax Then
			l\lightMove	= True
		ElseIf 	ay <> lay Then
			l\lightMove	= True
		ElseIf 	az <> laz Then
			l\lightMove	= True
		EndIf 	
		
		 
	Else
		Return -1 								; when the light is switch off => recompute quad 
	EndIf

	Return l\lightMove
	
End Function


Function GOM_api_planDistance#(o1,o2)
;--------------------------------------------------------------------------------------------
; compute the distance in x and z in a plan		
;--------------------------------------------------------------------------------------------

	x#	= EntityX(o1,True) - EntityX(o2,True)
	x 	= x * x
	
	z#	= EntityZ(o1,True) - EntityZ(o2,True)
	z 	= z * z
	
	x = x + z
		
	Return x

End Function




Function GOM_api_objectIsMoving(o.GOM_object,lightMove)
;--------------------------------------------------------------------------------------------
; this function detect id the object is moving : translation, rotation or animation		
;--------------------------------------------------------------------------------------------
	
	If o\objectMove	= -1 Then o\objectMove	= 2 : Return

;If Instr(o\title,"foret") Then Stop
	
	o\objectMove	= 0

	opx				= o\px
	opy				= o\py
	opz				= o\pz
	oax#			= o\ax
	oay#			= o\ay
	oaz#			= o\az

	o\px			= EntityX(o\parent,True)
	o\py			= EntityY(o\parent,True)
	o\pz			= EntityZ(o\parent,True)	
	o\ax			= EntityPitch(o\idObject,True)
	o\ay			= EntityYaw	 (o\idObject,True)
	o\az			= EntityRoll (o\idObject,True)
	
	px				= o\px
	py				= o\py
	pz				= o\pz

	If 	px <> opx Then
		o\objectMove 	= 2
		Return 
	ElseIf 	py <> opy Then
		o\objectMove 	= 2
		Return
	ElseIf 	pz <> opz Then
		o\objectMove 	= 2
		Return
	EndIf 		
	
	If lightMove Then 
		o\objectMove 	= 1
		Return
	EndIf 
	
	ax				= o\ax
	ay				= o\ay
	az				= o\az
			
	If 	ax <> oax Then
		o\objectMove 	= 1
		Return 
	ElseIf 	ay <> oay Then
		o\objectMove 	= 1
		Return
	ElseIf 	az <> oaz Then
		o\objectMove 	= 1
		Return
	EndIf 	 
	

	If o\animated 
		If o\class = "mesh" Then
			If Animating(o\idObject) Then o\objectMove = 1
		ElseIf o\class = "md2" Then
			If MD2Animating(o\idObject) Then o\objectMove = 1
		EndIf
	EndIf
	
End Function

Function GOM_api_receiverTexture(o.GOM_Object,camerascene)
;--------------------------------------------------------------------------------------------
; this function check if the object is closed from a shadow maker			
; If it is the case the texture of the shadow maker is applied on the object
;--------------------------------------------------------------------------------------------
	
	d = 99999
	
	; in order to avoid blinking  texture
	If o\shadowReceiverCamera	> 0 Then 
		o\shadowReceiverCamera 	= 0
	Else
		o\shadowReceiverTexture = gGOM_player\textureWhite
	EndIf
	

	For oo.GOM_object = Each GOM_object
		
		If o\idObject <> oo\idObject
			If oo\light <> Null
				If GOM_api_ShadowNo(o,oo\idObject) Then 
				;the projection on the object on a different scene
					If o\shadowReceiverCamera = 0 Or o\idScene = -1
						If o\idScene <> gGOM_scene\idScene Or o\mainScene = False 
							dist = EntityDistance(o\idObject,oo\idObject)
							If dist  < d 
								range =  oo\volrange + o\volrange ; 
								If dist < range Then 
									d = dist 
									
									If EntityInView (o\idObject,oo\cameraShadow ) Then
										dplan	= GOM_api_planDistance(o\idObject,oo\light\idLight)
										If (dplan > oo\camPlanDistance Or o\mainScene = True ); the receiver is in front of the object 
									
									
											;If EntityVisible(camerascene,oo\idobject)
											;If EntityInView(oo\idobject,camerascene)
	
												If debugg Then DebugLog "o=" + o\title + " oo=" + oo\title
												
	
												o\shadowReceiverTexture = oo\idQuadTexture
												o\shadowReceiverCamera	= oo\cameraShadow
												If oo\idscene < 0 Then o\timerShadowed 	= oo\timer ; synchronisation when it is teh main character
											;EndIf
											;EndIf
										EndIf 
									EndIf
								EndIf
							EndIf
						EndIf
					EndIf
				EndIf
			EndIf
		EndIf
	Next
		
	If o\shadowReceiverTexture = 0 Then o\shadowReceiverTexture = gGOM_player\textureWhite
	
	If o\shadowReceiverCamera > 0 Then CameraProjMode o\shadowReceiverCamera,2
	
	GOM_api_receiverTextureChild(o,o\shadowReceiverCamera,o\shadowReceiverTexture)
	
	If o\shadowReceiverCamera > 0 Then CameraProjMode o\shadowReceiverCamera,0
	
End Function

Function GOM_api_receiverTextureChild(o.GOM_Object,camera,tex)
;--------------------------------------------------------------------------------------------
; this function check if the object is done with bone and read all the bones/mesh			
;--------------------------------------------------------------------------------------------
		
	entity = o\idObject
	
	nbsurf = CountSurfaces(entity )
	
	If nbsurf = 0 Then 
		
		GOM_api_receiverTextureuvchild(o\idObject,o\textureSize,camera,tex,-1)

	Else
		;If camera > 0 Then Stop
		If tex > 0 Then EntityTexture entity ,tex,0,1
		GOM_api_receiverUV(o\idObject , o\textureSize ,camera,-1)
		; id the anim mesh have mesh on bone
		GOM_api_receiverTextureuvchild(o\idObject,o\textureSize,camera,tex,-1)
	EndIf
	
End Function

Function GOM_api_receiverTextureuvchild(entity,textureSize#,camera,tex,shadowHeight)
;--------------------------------------------------------------------------------------------
; this function read all the bones tree			
;--------------------------------------------------------------------------------------------

	max = CountChildren(entity )
			
	For childcount = 1 To  max

		child = GetChild(entity,childcount) 
		class$ = EntityClass(child )
		If EntityClass(child ) = "Mesh"
			GOM_api_receiverUV(child ,textureSize#,camera,shadowHeight) 
				 
			If tex > 0 Then EntityTexture child ,tex,0,1 :
			
			GOM_api_receiverTextureuvchild(child ,textureSize#,camera,tex,shadowHeight)
		EndIf

	Next
		
End Function

Function GOM_api_receiverUV(entity ,textureSize#,camera,ymax )
;--------------------------------------------------------------------------------------------
; this function computes the UV coordinate of the quad in order to get a correct shadow			
;--------------------------------------------------------------------------------------------

	If camera <= 0 Then Return

	nbsurf = CountSurfaces(entity )
	uv = False
	
	px#	= EntityX(entity,True)
	py#	= EntityY(entity,True)
	pz#	= EntityZ(entity,True)
	
	For s= 1 To  nbsurf 
		surf  	= GetSurface(entity , s)
		cv% 	= CountVertices(surf)-1
		
		For v=0 To cv
		
			TFormPoint 		VertexX(surf, v), VertexY(surf, v), VertexZ(surf, v), entity , 0
			y# 				= TFormedY()
	
			If y >= ymax And ymax > 0 Then 
				VertexTexCoords surf, v, 65535, 65535, 0, 1
			Else
				CameraProject 	camera,TFormedX(),y,TFormedZ()
				
				VertexTexCoords surf, v, ProjectedX()/textureSize, ProjectedY()/textureSize, 0, 1
			EndIf

			uv = True
		Next
	Next

	Return uv

End Function

Function GOM_api_sceneWhereIsPlayer()
;--------------------------------------------------------------------------------------------
; this function identify on which scene the player is 		
;--------------------------------------------------------------------------------------------
	
	collision 		= CountCollisions(gGOM_player\idPlayer)
	s.GOM_scene = gGOM_scene

	If collision 	> 0 Then 
		For i = 1 To collision 
			entity = CollisionEntity(gGOM_player\idPlayer,i)
			For gGOM_scene	= Each  GOM_scene
				If gGOM_scene\Scene\idObject = entity Then 
					
					If s\Scene\idObject <> gGOM_scene\Scene\idObject			; inforce the quad computation when 3D object is at the limit of teh scenery
						gGOM_player\Player\objectMove = -1
						AmbientLight gGOM_scene\ambientLightr,gGOM_scene\ambientLightg,gGOM_scene\ambientLightb
					EndIf
					Return
				EndIf
			Next
		Next		
	Else
		; if the object is not in contact with the ground
		LinePick (gGOM_player\Player\px,gGOM_player\Player\py,gGOM_player\Player\pz,0,-gGOM_player\camera\range,0)
		entity 	= PickedEntity()

		For gGOM_scene	= Each  GOM_scene
			If gGOM_scene\Scene\idObject = entity Then 
				If s\Scene\idObject <> gGOM_scene\Scene\idObject			; inforce the quad computation when 3D object is at the limit of teh scenery
					gGOM_player\Player\objectMove = -1
					AmbientLight gGOM_scene\ambientLightr,gGOM_scene\ambientLightg,gGOM_scene\ambientLightb
				EndIf
				Return
			EndIf
		Next
	EndIf
	

	If entity > 0 Then 
		gGOM_scene 		= s
		o.GOM_object 	= gom_api_objectSearch(entity)
		
		If o <> Null Then 
			GOM_api_runtimeError("GOM_api_sceneWhereIsPlayer","the object scene in collision is not identified as a scene",o\title + " = " + entity + " = " + EntityName(entity))
		Else
			GOM_api_runtimeError("GOM_api_sceneWhereIsPlayer","the object scene in collision is not identified as a GOM object", entity + " = " + EntityName(entity))
		EndIf
		
		Return 
	Else
		; should never happen except if there is no object below the player => link to the camera range 
		; or the scenery has a hole => redesign teh scenery with a 3D tool  
		GOM_api_runtimeError("GOM_api_sceneWhereIsPlayer","the player is lost in the space", gGOM_player\player\title ,True)
	EndIf
End Function


Function GOM_api_ShadowNo(o.GOM_object,idObject)
;--------------------------------------------------------------------------------------------
; this function check if a projected shadow should be done		
;--------------------------------------------------------------------------------------------
	
	If o = Null Then Return False
	
	While o\shadowNo[i] > 0 And i < 11
		If o\shadowNo[i] = idObject Then Return False 
		i = i + 1
	Wend
	
	Return True

End Function

Function GOM_________API__General()
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	
End Function


Function GOM_api_CameraCreate(cam)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	gGOM_camera.GOM_camera	= New GOM_camera
	gGOM_camera\idCamera	= cam
	gGOM_camera\idScene		= gGOM_scene\idScene
	
End Function

Function GOM_api_CameraDelete(cam)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	gGOM_camera.GOM_camera = GOM_api_CameraSearch(cam)
	
	If gGOM_camera <> Null Then 
		Delete gGOM_camera
		Return True
	EndIf
	
		
	Return False
	
End Function



Function GOM_api_CameraSearch.GOM_camera(cam)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	For gGOM_camera.GOM_camera	= Each GOM_camera
		If gGOM_camera\idCamera	= cam Then Return gGOM_camera
	Next
	
	If gGOM_camera = Null Then GOM_api_runtimeerror("GOM_api_CameraSearch","the camera doesn't exist",cam ) : Return 
		
	Return Null
	
End Function

Function GOM_api_cameraTitle(idObject,title$)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	gGOM_camera.GOM_camera	= GOM_api_CameraSearch(idObject)
	
	gGOM_camera\title 		= title


End Function

Function GOM_api_cameraShadow(o.GOM_object,colorCls=255,camRangeMin#=0.1,camRangeMax=2000)
;--------------------------------------------------------------------------------------------
; this function create the camera used to make shadow 
;--------------------------------------------------------------------------------------------
	
	vpSizeX		= o\textureSize
	vpSizeY		= o\textureSize

	
	If gGOM_scene\vpOriginX + vpSizeX > GraphicsWidth()
		gGOM_scene\vpOriginX	= 0			
		gGOM_scene\vpOriginY	= gGOM_scene\vpOriginY + vpSizeY
		If gGOM_scene\vpOriginY + vpSizeY > GraphicsHeight() Then 
			gGOM_scene\vpOriginX = 0
			gGOM_scene\vpOriginY = 0
		EndIf	
	EndIf
	
	o\cameraShadow	= CreateCamera()
	
	o\vpSizeX		= vpSizeX
	o\vpSizeY		= vpSizeY
	o\vpOriginX		= gGOM_scene\vpOriginX 
	o\vpOriginY		= gGOM_scene\vpOriginY
	
	gGOM_scene\vpOriginX = gGOM_scene\vpOriginX + vpSizeX
	
	CameraRange 	o\cameraShadow, camRangeMin	, camRangeMax	
	CameraClsColor	o\cameraShadow, colorCls, colorCls, colorCls
	CameraFogMode	o\cameraShadow, True
	CameraFogRange	o\cameraShadow, 0, 0
	;CameraFogColor 	o\cameraShadow, 255-o\shadowR,255-o\shadowg,255-o\shadowb

	If o\camZoom = 0 Then 
		o\camZoom#	= (1/(o\volrange*3))
		If o\camZoom> 0.02 Then o\camZoom = 0.02
	EndIf
	
	CameraZoom		o\cameraShadow, o\camZoom;0.02
	CameraViewport	o\cameraShadow, o\vpOriginX , o\vpOriginY ,o\vpSizex,o\vpSizey
	CameraProjMode 	o\cameraShadow, 0
		
End Function

Function GOM_api_entityInView(camera,idObject,idQuad,volRange)
;--------------------------------------------------------------------------------------------
; this function checks is an object or is quad is in the camera view
;--------------------------------------------------------------------------------------------

	If EntityInView (idObject,camera) Then 
		Return True 
	Else
		If idQuad > 0 Then 														; display the shadow if the quad is in the camera view
			If EntityInView (idQuad,camera) Then 									; avoid that the shadow disappear when the object is not in the camera view
				d = EntityDistance (idQuad,camera)
				If d < volrange
					Return True 
				EndIf
			EndIf
		EndIf
	EndIf
	
	Return False
	
End Function

Function GOM_api_getFile$(file$)
;--------------------------------------------------------------------------------------------
; get the name of the file at the end of the field
;--------------------------------------------------------------------------------------------
	l = Len(file)
	
	For i = l To 1 Step -1
		If Mid(file,i,1) = "\" Then Exit
	Next
	
	
	file$ = Mid(file,i+1)
	
	Return file

End Function


Function GOM_api_lightCreate(idLight,lightType,class$)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	If Abs(lightType) > 3 Then GOM_api_RuntimeError("GOM_api_lightCreate","CreateLight Type Not supported",lightType) : Return 

	l.GOM_light		= New GOM_light
	l\idLight		= idLight		
	l\idScene		= 0;gGOM_scene\idScene	
	l\lightType		= Abs(lightType)
	l\class			= class
	l\outer			= 90
	l\lightShadowMin= 200
	
End Function

Function GOM_api_lightControl$(l.GOM_light)
;--------------------------------------------------------------------------------------------
; this function control the values set in order to ensure that the shadow system works 
; properly
;--------------------------------------------------------------------------------------------
	Local error$

	If l\idLight <= 0 Then 
		error = error + "- Idlight should be fill with the reference of a Blitz 3D object." + Chr(10)
	Else
		Select Lower(EntityClass(l\idLight))
			Case "mesh"
			Case "pivot"
			Case "light"
			Default error = error + "- Idlight should be a Blitz 3D object as mesh or pivot of light." + Chr(10)
		End Select
	EndIf
	
	Select l\lightType
		Case GOM_SUN 	: error = error + GOM_api_SunControl(l\idLight,l\idScene,l\lightType)
		Case GOM_POINT	: error = error + GOM_api_SunControl(l\idLight,l\idScene,l\lightType)
		Case GOM_SPOT	: error = error + GOM_api_SunControl(l\idLight,l\idScene,l\lightType)
		Default error = error + "- The lightType value is wrong : " + l\lightType + "." + Chr(10)
	End Select
	
	If l\lightType <> GOM_SUN And l\range <= 0 Then 
		error = error + "- With POINT or SPOT light the range of the light is mandatory." + Chr(10)
	EndIf
	If l\lightType = GOM_SPOT And l\outer <= 0 Then 
		error = error + "- With SPOT light the outer angle of the light cone is mandatory." + Chr(10)
	EndIf
	
	If l\lightMove	<> 1 And l\lightMove	<> 0 Then 
		error = error + "- The lightMove value is wrong : " + l\lightMove + "." + Chr(10)
	EndIf
	
	Return error 
	
End Function



Function GOM_api_lightColor(idlight,r#,g#,b#)
;--------------------------------------------------------------------------------------------
; 		
;--------------------------------------------------------------------------------------------

	l.GOM_light = gom_api_lightSearch(idlight)
	
	If l = Null Then GOM_api_RuntimeError("GOM_api_lightColor","idlight does Not exist",idlight)  : Return 

	l\cr	= r
	l\cg	= g
	l\cb	= b
		
	If l\class = "light" Then Return True
	
	Return False

End Function

Function GOM_api_lightDelete(idLight)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	l.GOM_light = GOM_api_lightSearch(idLight)

	If l <> Null  Then 
		Delete l
		Return True
	EndIf
	
	Return False
	
End Function


Function GOM_api_LightConeAngles (idlight,outer)
;--------------------------------------------------------------------------------------------
; 		
;--------------------------------------------------------------------------------------------

	l.GOM_light = gom_api_lightSearch(idlight)
	
	If l = Null Then GOM_api_RuntimeError("GOM_api_LightConeAngles","idlight does Not exist",idlight) : Return 

	l\outer	= outer
	
	If l\class = "light" Then Return True

	Return False
	
End Function


Function GOM_api_lightSearch.GOM_light(idLight)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	Local l.GOM_light

	For l.GOM_light = Each GOM_light
		If l\idLight = idLight Then 
			Return l
		EndIf
	Next

	If l = Null Then GOM_api_runtimeError("GOM_api_lightSearch","the light is unknown",idLight)  

	Return Null

End Function

Function GOM_api_lightTitle(idlight,title$)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	l.GOM_light	= GOM_api_lightSearch(idLight)
	
	l\title		= title
	

End Function

Function GOM_api_LightSetRange(idLight,range#)
;--------------------------------------------------------------------------------------------
; this function replace the standard light range function from blitz		
;--------------------------------------------------------------------------------------------

	l.GOM_light = gom_api_lightSearch(idlight)
	
	If l = Null Then GOM_api_RuntimeError("GOM_api_LightSetRange","idlight does Not exist",idlight) : Return False

	l\range	= range
	
	If l\class = "light" Then Return True

	Return False

	
End Function

Function GOM_api_MeshWidth#(idObject)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	o.GOM_object = GOM_api_objectSearch(idObject)
	
	If o = Null Then Return 0
	
	If o\class = "mesh" Then 
		If FileType(o\file) = 1 Then 
			ob = LoadMesh(o\file)
		Else
			ob = idObject
		EndIf
		
		x#	= MeshWidth(ob)
		
		If FileType(o\file) = 1 Then FreeEntity ob
		  
		Return x
	Else
	
		Return 1
		
	EndIf
	

End Function

Function GOM_api_MeshHeight#(idObject)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idObject)
	
	If o = Null Then Return 0
	
	If o\class = "mesh" Then 
		If FileType(o\file) = 1 Then 
			ob = LoadMesh(o\file)
		Else
			ob = idObject
		EndIf
		
		x#	= MeshHeight(ob)
		
		If FileType(o\file) = 1 Then FreeEntity ob
		  
		Return x
	Else
	
		Return 1
		
	EndIf

	
End Function


Function GOM_api_MeshDepth#(idObject)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	o.GOM_object = GOM_api_objectSearch(idObject)
	
	If o = Null Then Return 0
	
	If o\class = "mesh" Then 
		If FileType(o\file) = 1 Then 
			ob = LoadMesh(o\file)
		Else
			ob = idObject
		EndIf
		
		x#	= MeshDepth(ob)
		
		If FileType(o\file) = 1 Then FreeEntity ob
		  
		Return x
	Else
	
		Return 1
		
	EndIf

End Function




Function GOM_api_objectSearch.GOM_object(idObject)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	For o.GOM_object = Each GOM_object
		If o\idObject = idObject Then 
			Return o
		EndIf
	Next
	
	If o = Null Then GOM_api_RuntimeError("GOM_api_objectSearch","the object does not exist",idObject ) : Return 
	
	Return Null

End Function

Function GOM_api_objectSetAnim(idObject,Anim)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	o.GOM_object 	= GOM_api_objectSearch(idObject)
	
	If o = Null Then Return
	
	o\animated = anim

End Function

Function GOM_api_objectTitle(idObject,title$)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	o.GOM_object = GOM_api_objectSearch(idObject)
	
	If o = Null Then GOM_api_RuntimeError("GOM_api_objectTitle","the Object does Not exist",idObject +" => " + title) : Return 
	
	o\title				= title
	NameEntity			idObject,o\title ; debug
	
End Function




Function GOM_api_runtimeError(func$,message$,value$,block=False)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	If gom\strict Or block
		RuntimeError "function :" + func  + Chr(10) + message + Chr(10) + value
	Else
		DebugLog "function :" + func
		DebugLog message 
		For i = 1 To Len(value) Step 80
			DebugLog Mid(value,i,80)
		Next
	EndIf
	
End Function

Function GOM_api_scaleEntity(idobject,sx#,sy#,sz#)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	o.GOM_Object = GOM_api_objectSearch(idobject)
	
	o\sx		= sx
	o\sy		= sy
	o\sz		= sz
	
	o\objectwidth 	= GOM_MeshWidth(idobject)	* sx
	o\objectHeight 	= GOM_MeshHeight(idobject)  * sy
	o\objectDepth 	= GOM_MeshDepth(idobject)	* sz
		
End Function

Function GOM_api_scaleMesh(idobject,sx#,sy#,sz#)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	o.GOM_Object = GOM_api_objectSearch(idobject)
	
	o\sx		= sx
	o\sy		= sy
	o\sz		= sz
	
	o\objectwidth 	= GOM_MeshWidth(idobject)
	o\objectHeight 	= GOM_MeshHeight(idobject)
	o\objectDepth 	= GOM_MeshDepth(idobject)
	

End Function

Function GOM_api_sceneControl()
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------
	
	Local error$
	
	For o.GOM_object = Each GOM_object
		If o\idScene <> -1 Then GOM_api_sceneSearch(o\idScene)
	Next

	For l.GOM_light = Each GOM_light
		If l\idScene <> -1 Then GOM_api_sceneSearch(l\idScene)
			
		lightSwitchOn = l\cr + l\cg + l\cb
		If lightSwitchOn Then error = error + GOM_api_lightControl(l)
	Next

	If Len(error) > 0 Then GOM_api_runtimeerror("GOM_api_sceneControl","GOM_api_sceneControl errors :" ,error) : Return 
	
End Function


Function GOM_api_sceneSearch(idObject)
;--------------------------------------------------------------------------------------------
; 			
;--------------------------------------------------------------------------------------------

	For gGOM_scene	= Each  GOM_scene
		If gGOM_scene\Scene\idObject = idObject Then Return gGOM_scene\idScene
	Next
	
	For gGOM_scene	= Each  GOM_scene
		If gGOM_scene\idScene = idObject Then Return gGOM_scene\idScene
	Next

	GOM_api_runtimeError("GOM_api_sceneSearch","the scene does Not exist",idScene )
	
	
End Function


Function GOM_api_sceneTriangle(surface=1)
;--------------------------------------------------------------------------------------------
; compute the size max od a traingle ( this is needed to calculate the quad later on)
; If it is not done and the size of triangle is greater than the size of the quad radius
; no shadow will appear
;--------------------------------------------------------------------------------------------
	
	scene 		= gGOM_scene\scene\idObject
	sx#			= gGOM_scene\scene\sx
	sz#			= gGOM_scene\scene\sz
	
	cs = CountSurfaces(scene )

	For k = 1 To cs
		surf 		= GetSurface(scene ,k)
		tris		= (CountTriangles(surf)-1)
		
		; search for the vertex closed form the object
		
		;ve = CountVertices(surf)

		For i = 0 To tris
			v = TriangleVertex(surf,i,0)
			;If v > ve Then Exit
			ox# = VertexX(surf,v) * sx
			oz# = VertexZ(surf,v) * sz

			For j = 1 To 2
				 
				v = TriangleVertex(surf,i,j)
				;If v > ve Then Exit
				x# = VertexX(surf,v) * sx
				z# = VertexZ(surf,v) * sz
				
				d#	= (x-ox)*(x-ox) + (z-oz)*(z-oz) ; avoid root squared computation
	
				If d > dist Then 
					dist = d
				EndIf
				ox = x
				oz = z
			Next	
		Next
		
	Next

	gGOM_scene\scene\triangleMaxSize	= Sqr(dist)
	
End Function 

Function GOM_api_SunControl$(idLight,idScene,lightType)
;--------------------------------------------------------------------------------------------
; This function control if a sun is unique or not used with light			
;--------------------------------------------------------------------------------------------
	
	For ll.GOM_light = Each GOM_light
		lightSwitchOn = ll\cr + ll\cg + ll\cb
		If lightSwitchOn ;And GOM_api_sceneIsEqual(idScene,ll\idScene) = TrueAnd GOM_api_sceneIsEqual(idScene,ll\idScene) = True
			If lightType = GOM_SUN  And idLight <> ll\idLight Then 
				Return "- The sun must be unique in a scene : " + ll\idscene + "=>" + ll\title + Chr(10)
			ElseIf lightType <> GOM_SUN  And ll\lightType = GOM_SUN Then
				Return "- The light point and spot could not be mixed with a SUN into a scene : "+ ll\idscene + "=>" + ll\title + Chr(10)
			EndIf
		EndIf
	Next

	Return ""
	
End Function