; 	Title 			: program to test the SUN and LIGHT shadow 
;	Development 	: Philippe C / HautVent
;	Test 			: Philippe C / HautVent
;
;
;	test program
;
;----------------------------------------------------------------------------------------------
;		
; 
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
;
;----------------------------------------------------------------------------------------------

Global PUB	= True

Include "lib\gom_shadow----------v01-00.bb"

Const sWidth 		= 800
Const sHeight 		= 600
Const sWidthd2		= sWidth/2
Const sHeight2		= sHeight/2
Const cscene		= 1
Const cjoueur		= 2

Print "pour wako3D :"
Print 
rep$ = Input("affichage plein cran o/n : ")


If Lower(rep) = "o" Then 
	Graphics3D 		sWidth ,sHeight,0,1
Else
	Graphics3D 		sWidth ,sHeight,0,2
EndIf
SetBuffer 		BackBuffer()


; by default strict is set to true 
; true = run time error windows are displayed and the program stops
; false = all the debuglog messages are displayed but wrong shadow could be displayed display or errors could appear later on as memory violation
GOM\strict	= True


; SCENE LAND =========================================================================================
sc# 	= 0
factor# = 0.1
; ciel	-------------------------------------------------------------------------------
ciel			= CreateSphere()
EntityTexture	ciel,LoadTexture("media\front.jpg");sky-sphere.jpg")
FlipMesh		ciel
ScaleEntity		ciel, 80  ,80 ,80
EntityType		ciel,cscene
EntityPickMode 	ciel,2
EntityFX		ciel,1

; player ------------------------------------------------------------------------------- GOM
sc				= 0.5 * factor
p 				= LoadMesh("media\mak_robotic.3DS")
hjoueur			= MeshHeight(p)*sc
wjoueur			= MeshDepth(p)*sc
If MeshWidth(p)*sc < wjoueur Then wjoueur = MeshWidth(p)*sc

FreeEntity		p

joueur			= CreatePivot()
EntityRadius 	joueur,wjoueur,(hjoueur/2.0)+0.15
x = -11 : z = -43
PositionEntity 	joueur,x,hjoueur/2+3.91,z
EntityType		joueur,cjoueur

	 
		joueurA				= GOM_LoadAnimMesh("media\mak_robotic.3DS",joueur)
		GOM_scaleEntity 	joueurA,sc  ,sc    ,sc
		GOM_zoomSize		(joueurA,0.077)
		GOM_sceneObjectAll	joueurA; <= the player could belong to all the scene
		GOM_shadowHeight	(joueurA,hjoueur)
		GOM_shadowTime		(joueurA,10)
		
EntityFX		joueurA,0
RotateEntity	joueurA,0,180,0	
PositionEntity  joueurA,0,-(hjoueur/2.0)-0.1,0	

joueurA_idle	= 0
joueurA_run		= LoadAnimSeq(joueura,"media\mak_running.3ds")

	gom_Animate	joueurA,1,4,joueurA_idle
	

;load flare	---------------------------------------------------------------------------- GOM

flare			= LoadSprite("media\flare.bmp",1)
ScaleSprite 	flare,5*sc,5*sc
HideEntity 		flare
eyepos			= FindChild(joueurA,"eye")
eyeflare		= CopyEntity(flare,eyepos)
MoveEntity 		eyeflare,0,0,-2
FreeEntity		flare

		lightLamp		= GOM_CreateLight(3,eyeflare)
		GOM_sceneTitle	(lightLamp,"Robotlamp") 
		GOM_LightColor	lightLamp,0,0,0
		GOM_LightRange	lightLamp,20
	
RotateEntity	lightLamp,0,180,0




; scene land 	------------------------------------------------------------------------ GOM

		scene 			= GOM_LoadMesh("media\island.3ds")
		GOM_scaleEntity	scene, 3*factor  ,0.15*factor ,3*factor 
		GOM_sceneCreate	(scene,25,25,25); <= all the objects created after this ligne belong to the this scene 
	
EntityType		scene, cscene
EntityPickMode 	scene, 2


;trees	------------------------------------------------------------------------------- GOM

Dim tree(10,2)
i = 1
x = 1
z = 2
tree(1,x) = 300 	: tree(1,z) = 30 
tree(2,x) = 80 		: tree(2,z) = 30 
tree(3,x) = 100 	: tree(3,z) = 60 
tree(4,x) = 110 	: tree(4,z) = 400 
tree(5,x) = 220 	: tree(5,z) = 30 
tree(6,x) = 140 	: tree(6,z) = -90 
tree(7,x) = 150 	: tree(7,z) = 60 
tree(8,x) = 170 	: tree(8,z) = 130 
tree(9,x) = 180 	: tree(9,z) = 30 
tree(10,x) = -350 	: tree(10,z) = 50 

sc#				= 4*factor
nbTree	= 10
For i = 1 To nbTree-1

	pivot = CreatePivot()
	
			tree(i,0)		= GOM_LoadMesh("media\tree.b3d",pivot)
			GOM_scaleMesh 	tree(i,0)	 ,sc  ,Rnd(sc,2*sc) ,sc
			GOM_textureSize	(tree(i,0),128)
			GOM_zoomSize	(tree(i,0),0.015)
				
	xx#				= tree(i,x)*factor
	zz#				= tree(i,z)*factor
	h#				= MeshHeight(tree(i,0))
	PositionEntity	pivot,xx,hauteurScene(scene,xx,zz)+h/2,zz
	PositionEntity	tree(i,0),0,-h/2+0.1,0
	EntityType		tree(i,0),cscene
Next

; foret ------------------------------------------------------------------------------- GOM

i = nbTree
; pivot cer pour que le soleil lorsqu'il tourne soit toujours bien centr
pivotForet		= CreatePivot()

		tree(i,0)		= GOM_LoadMesh("media\foret.b3d",pivotForet)
		GOM_scaleMesh 	tree(i,0)	 ,sc  ,sc    ,sc
		GOM_zoomSize	(tree(i,0),0.014)
	
h#				= MeshHeight(tree(i,0))/2
xx#				= tree(i,x)*factor
zz#				= tree(i,z)*factor

PositionEntity	pivotForet,xx,hauteurScene(scene,xx,zz)+h-1,zz	
PositionEntity	tree(i,0),-1,-h-0.0+1.1,-2
EntityType		tree(i,0),cscene



; sun	------------------------------------------------------------------------------- GOM

sun 			= CreatePivot()
sun1			= CreateSphere(4,sun)
ysunMin 		= 25
EntityFX		sun1,1

		lightSun			= GOM_CreateLight(1,sun1)
		GOM_LightColor 		lightSun,255,255,255
		GOM_sceneTitle		(lightSun,"sun")
		GOM_LightRange		lightSun,1000
		GOM_lightHeigthMin	lightSun,ysunMin 

y 				= 70

PositionEntity 	sun1,0,y,0,True
EntityColor 	sun1,255,255,255
PointEntity 	lightSun,scene

; FIN SCENE =========================================================================================





; NOUVELLE SCENE =========================================================================================

; temple	---------------------------------------------------------------------------- GOM
xx 				= -100 * factor
zz 				= -500 * factor

		temple1 		= GOM_LoadMesh("media\boiteSocle.3ds")
		GOM_scaleEntity	temple1,1,1,2
		GOM_sceneCreate(temple1,25,25,25) ; <= all the objects created after this ligne belong to the this scene 
	
EntityTexture	temple1 ,LoadTexture("media\Wood03.png") 
EntityType		temple1 ,cscene
EntityPickMode 	temple1 ,2
PositionEntity	temple1 ,xx,hauteurScene(scene,xx,zz)+1,zz
RotateEntity 	temple1 ,0,180,0

		temple 					= GOM_LoadMesh("media\boite.3ds")
		GOM_sceneCreate			(temple,25,25,25)
		GOM_scaleEntity			temple,1,1,2
		GOM_sceneObjectSurface	(temple ,1)
		GOM_sceneObjectSurface	(temple ,2)

EntityTexture	temple ,LoadTexture("media\Wood03.png") 
EntityType		temple ,cscene
EntityPickMode 	temple ,2
PositionEntity	temple ,xx,hauteurScene(scene,xx,zz)+0.1,zz
RotateEntity 	temple ,0,180,0



;lights	------------------------------------------------------------------------------- GOM

; the light is identified with a sphere
light 			= CreatePivot()
light1			= CreateSphere(4,light)
PositionEntity 	light1,xx,12,zz+10
EntityColor 	light1,255,0,0
	
		; create the light associated to the sphere
		light11				= GOM_CreateLight(2,light1)
		GOM_LightColor 		light11,255,0,0
		GOM_LightRange 		light11,11
		GOM_sceneTitle		(light11,"sphereLight11")
		GOM_lightShadowMin	(light11,255)

; the light is identified with a cone
light2			= CreatePivot()
light21			= CreateCone()
EntityParent	light21,light2
PositionEntity 	light21,xx,10,zz-15
EntityColor 	light21,255,255,0

		; create the light associated to the cone
		light22 			= GOM_CreateLight(3,light21)
		GOM_LightColor 		light22,255,255,0
		GOM_LightConeAngles light22,0,45
		GOM_LightRange		light22,9
		GOM_sceneTitle		(light22,"coneLight22")
		GOM_lightShadowMin	(light22,255)
		
MoveEntity		light22,0,-1,0
RotateEntity	light22,90,0,0


; colonne	----------------------------------------------------------------------------- GOM

Dim cyl(6)
xx = xx + 2
zz = zz + 2
yy# = 8.7
; several column could be cerated : for the moment only 2 
For i = 1 To 1 Step 2
	j = i
	
		cyl(j) 			= GOM_CreateCylinder()
		GOM_sceneTitle	(cyl(j),"cylinder_"+"red")
		GOM_scaleMesh	cyl(j),1,5,1
		GOM_shadowHeight(cyl(j),-2)
		
	EntityType		cyl(j),cscene
	EntityPickMode 	cyl(j),2
	PositionEntity	cyl(j) ,xx,yy,zz	
	EntityColor 	cyl(j),255,0,0

	j = i + 1
	xx = xx - 5	
	
		cyl(j) 			= GOM_CreateCylinder()
		GOM_sceneTitle	(cyl(j),"cylinder_"+"green")
		GOM_scaleMesh	cyl(j),1,5,1
		GOM_shadowHeight(cyl(j),-2)

	EntityType		cyl(j),cscene
	EntityPickMode 	cyl(j),2
	PositionEntity	cyl(j) ,xx,yy,zz
	EntityColor 	cyl(j),0,255,0
	
	zz = zz - 5
	xx = xx - 5
Next
	

; FIN NOUVELLE SCENE =========================================================================================

; camera game -------------------------------------------------------------------------- GOM

		camera			= GOM_CreateCamera(joueur)
		GOM_CameraRange camera,.01,1000
	
PositionEntity 	camera,0,2*hjoueur,-4.0*hjoueur
PointEntity		camera,joueur 

; collisions --------------------------------------------------------------------------

Collisions 	cjoueur,cscene,2,2

spd# 	= 2 * factor
tt#		= 0.02

ysunMax = 80
ysunAve	= 60

ysunLight = 255/ysunMax 

night 	= 10
anim	= joueurA_idle

; preparation -------------------------------------------------------------------------- GOM

	GOM_scenePrepare(Temple) ;--------------------------------------------- GOM


While Not KeyDown(1)
	
	If showSun Then 
		TurnEntity	sun,0.1,0,0
	Else
		TurnEntity	sun,0.3,0,0
	EndIf
	
	
	If MilliSecs() > treeTimer
		treeTimer = MilliSecs() + 200
		For i = 1 To nbTree-1
			TurnEntity tree(i,0),Rnd(-1,1),0,0
			If EntityRoll(tree(i,0)) < -1 Or EntityRoll(tree(i,0)) > 1 Then
				RotateEntity tree(i,0),0,0,0
			EndIf
		Next	
	EndIf

	
	; move the light
	If light > 0 And light2 > 0 Then 
		t = t + 1
		If t > 450 Then tt = tt * -1 : t = 0
		TranslateEntity light,tt,0,0
		
		TurnEntity light2,tt/5,0,0
	EndIf
	
	; sun rise and sun set , lamp swictch on and swictch off
	y = EntityY(sun1,True)
	If y < ysunMin Then 
		If showSun = True Then 
			showSun 		= False			
			HideEntity		(sun1)
			
			TurnEntity 		sun,100,0,0
			GOM_LightColor	lightSun,0,0,0
			EntityFX		ciel,0 ;sky without sun
		EndIf
		If lamp = False
			lamp = True
			If eyeflare > 0  Then ShowEntity		(eyeflare)
			If lightLamp > 0 Then GOM_LightColor	lightLamp,0,0,255
		EndIf
	Else
	
		If y < ysunAve  
			l = y*ysunLight
		Else
			l = 255
		EndIf
		If l <> lum
			lum = l
			GOM_LightColor	lightSun,l,l,l 
		EndIf
	
		If showSun = False Then 
			EntityFX		ciel,1 ; sky with sun
			showSun 		= True
			lamp			= False
			ShowEntity		(sun1)
			If eyeflare > 0  Then HideEntity		(eyeflare)
			If lightLamp > 0 Then GOM_LightColor	lightLamp,0,0,0

		EndIf
	EndIf
	
	camera	(key,joueur,camera,spd,sWidthd2,sHeight2) 
	
	anim 	= player(joueur,spd,factor,joueurA,anim,joueurA_idle,joueurA_run)
	
	UpdateWorld()	
		
		
		GOM_sceneShadow(joueur,joueurA,camera) ;--------------------------------------------- GOM

		
	RenderWorld
	
	
	Color 255,255,255
	lig = 0

	lig = lig + 20 : Text 0,sHeight-lig ,"fps=" + fps + " trisrendered=" + TrisRendered()
	
	Flip
	
	Gosub fps
	
Wend



End

;///////////////////////////////////////////////////////////////////////////////////////////////// FUNCTIONS

.fps

	If MilliSecs() > timerFps Then 
		timerFps 	= MilliSecs() + 1000 
		FPS 			= FPSCount 
		FPSCount 		= 0 
		FPSreal 		= fRate - ftime3
	Else
		FPSCount 		= FPSCount + 1
	EndIf

Return

Function camera(key,joueur,camera,spd#,sWidthd2=0,sHeight2=0)
	; numeric keyboard 4 & 6 , 2 & 8
	MoveEntity 		camera,0,(KeyDown(77)-KeyDown(75))*spd,(KeyDown(72)-KeyDown(80))*spd 
	
	If Key > 0 Then 
		EntityParent 	camera,0
		TurnEntity 		camera,-MouseYSpeed()*0.25,-MouseXSpeed()*0.25,0
		RotateEntity 	camera,EntityPitch(camera,True),EntityYaw(camera,True),0
		If sWidthd2 > 0 And sHeight2 >  0 Then  MoveMouse sWidthd2,sHeight2
	Else
		EntityParent 	camera,joueur
		PointEntity	camera,joueur	; ctrl
	EndIf
End Function


Function character(r=255,g=0,b=0,parent=0,scale#=3)

	joueur			= CreateSphere(8,parent)
	
	ScaleMesh 		joueur,1,scale,1

	EntityColor 	joueur,r,g,b
		

	Return joueur
	
End Function



Function hauteurScene#(scene,x,z)

	LinePick 		(x,1000,z,0,-2000,0)

	Return PickedY()
	
End Function

Function player(joueur,spd#,factor#,joueurA,anim,idle,run)

	z = (KeyDown(203)-KeyDown(205) )*4
	x = (KeyDown(200)-KeyDown(208) )
	
	; player don't move when 
	If CountCollisions(joueur) > 0 	Then move = False
	If x <> 0 Or z <> 0 			Then move = True
	If move Then 
		;MoveEntity 		joueur,0,0,x*spd

		MoveEntity 		joueur,0,-0.5*factor,x*spd
		RotateEntity 	joueur,0,z+EntityYaw(joueur),0
	EndIf
	
	If x = 0 And anim = run
		anim = idle
		Animate		joueurA,1,1,anim 
	EndIf
	If x > 0 And anim = idle
		anim = run
		Animate		joueurA,1,1.5,anim 
	EndIf

	
	Return move
	
End Function