; 	Title 			: program to test the SUN and LIGHT shadow 
;	Development 	: Philippe C / HautVent
;	Test 			: Philippe C / HautVent
;
;
;	test program
;
;----------------------------------------------------------------------------------------------
;		
; 
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
;
;----------------------------------------------------------------------------------------------

Global PUB	= True


Include "lib\gom_shadow----------v01-00.bb"
gom\strict = False

Const sWidth 		= 800
Const sHeight 		= 600
Const sWidthd2		= sWidth/2
Const sHeight2		= sHeight/2
Const cscene		= 1
Const cjoueur		= 2

Graphics3D 		sWidth ,sHeight,0,2

SetBuffer 		BackBuffer()
AmbientLight	25,25,25

;----------------------------------------------------------------------------------------------
; scene 1----------------------------------------------------------------------- GOM
;----------------------------------------------------------------------------------------------
size = 40

		scene 			= GOM_CreateCube()
		GOM_ScaleEntity	scene, size,0.1,size
		GOM_sceneCreate	(scene,25,25,25); <= all the objects created after this ligne belong to the this scene 

EntityColor 	scene, 255,0,0
EntityType		scene,cscene
EntityPickMode 	scene, 2

; objet ------------------------------------------------------------------------------- GOM

		cyl1			= GOM_CreateCylinder()
		GOM_scaleMesh 	cyl1	 ,2  ,10    ,2
		GOM_zoomSize	(cyl1,0.01)
		GOM_sceneTitle	(cyl1,"green")
		GOM_shadowHeight(cyl1,MeshHeight(cyl1))
				
PositionEntity	cyl1,-15,9.6,10
EntityColor 	cyl1,0,255,0
ResetEntity 	cyl1
EntityType		cyl1,cscene

		cyl2			= GOM_CreateCylinder()
		GOM_scaleMesh 	cyl2	 ,2  ,10    ,2
		GOM_zoomSize	(cyl2,0.01)
		GOM_shadowTime	(cyl2,10)
		GOM_sceneTitle	(cyl2,"blue")
		GOM_shadowHeight(cyl2,MeshHeight(cyl2))

PositionEntity	cyl2,15,9.6,10
EntityColor 	cyl2,0,0,255
ResetEntity 	cyl2
EntityType		cyl2,cscene

		cyl3			= GOM_CreateCylinder()
		GOM_scaleMesh 	cyl3	 ,2  ,10    ,2
		GOM_zoomSize	(cyl3,0.01)
		GOM_shadowTime	(cyl3,10)
		GOM_sceneTitle	(cyl3,"redblue")
		GOM_shadowHeight(cyl3,MeshHeight(cyl2))

PositionEntity	cyl3,0,9.6,-10
EntityColor 	cyl3,255,0,255
ResetEntity 	cyl3
EntityType		cyl3,cscene




;----------------------------------------------------------------------------------------------
; scene 2----------------------------------------------------------------------- GOM
;----------------------------------------------------------------------------------------------
size = 20

		scene2b			= GOM_Createcube()
		GOM_ScaleEntity	scene2b, size,0.1,size
		GOM_zoomSize	(scene2b,0.005)
		GOM_sceneTitle	(scene2b,"scene2b")
		GOM_shadowTime	(scene2b,10)

EntityColor 	scene2b, 255,0,0
PositionEntity 	scene2b,0,20,0


		scene2 			= GOM_Createcube()
		GOM_ScaleEntity	scene2 , size,0.1,size
		GOM_sceneCreate	(scene2 ,25,25,25); <= all the objects created after this ligne belong to the this scene 

EntityColor 	scene2 , 255,0,0
EntityType		scene2 ,cscene
EntityPickMode 	scene2 , 2
PositionEntity 	scene2 ,0,20,0

; special character ----------------------------------------

sc#				= 0.2
p 				= LoadMesh("media\mak_robotic.3DS")
hjoueur#		= MeshHeight(p)*sc
wjoueur#		= MeshDepth(p)*sc
If MeshWidth(p)*sc < wjoueur Then wjoueur = MeshWidth(p)*sc

FreeEntity		p

pivot1			= CreatePivot()
joueur1			= CreatePivot(pivot1)
EntityRadius 	joueur1,wjoueur,(hjoueur/2.0)
PositionEntity 	joueur1,0,hjoueur/2+21,5
EntityType		joueur1,cjoueur
ResetEntity 	joueur1

	joueurA1			= GOM_LoadAnimMesh("media\mak_robotic.3DS",joueur1)
	GOM_shadowHeight	(joueurA1,hjoueur)
	GOM_sceneTitle		(joueurA1,"robot1")
	GOM_shadowTime		(joueurA1,0)
	GOM_scaleEntity 	joueurA1,sc  ,sc   ,sc
	GOM_zoomSize		(joueurA1,0.02)

	
joueurA_run1		= LoadAnimSeq(joueura1,"media\mak_running.3ds")

	gom_Animate		joueurA1,1,1,joueurA_run1

RotateEntity	joueurA1,0,90,0		
PositionEntity  joueurA1,0,-(hjoueur/2.0)+0.5,0


;----------------------------------------------------------------------------------------------
; sun		------------------------------------------------------------------------------- GOM
;----------------------------------------------------------------------------------------------

sun 			= CreatePivot()
sun1			= CreateSphere(4,sun)
ysunMin 		= 25
EntityFX		sun1,1

		lightSun			= GOM_CreateLight(1,sun1)
		GOM_LightColor 		lightSun,255,255,255
		GOM_sceneTitle		(lightSun,"sun")
		GOM_LightRange		lightSun,1000
		 

PositionEntity 	sun1,0,45,60,True
EntityColor 	sun1,255,255,255
PointEntity 	lightSun,scene


;----------------------------------------------------------------------------------------------
; player 	------------------------------------------------------------------------------- 
;----------------------------------------------------------------------------------------------

sc#				= 0.2
p 				= LoadMesh("media\mak_robotic.3DS")
hjoueur#		= MeshHeight(p)*sc
wjoueur#		= MeshDepth(p)*sc
If MeshWidth(p)*sc < wjoueur Then wjoueur = MeshWidth(p)*sc

FreeEntity		p
pivot			= CreatePivot()
joueur			= CreatePivot(pivot)
EntityRadius 	joueur,wjoueur,(hjoueur/2.0)
PositionEntity 	joueur,0,hjoueur/2,25
EntityType		joueur,cjoueur
ResetEntity 	joueur

	joueurA				= GOM_LoadAnimMesh("media\mak_robotic.3DS",joueur)
	GOM_shadowHeight	(joueurA,hjoueur)
	GOM_sceneTitle		(joueurA,"robot")
	GOM_shadowTime		(joueurA,10)
	GOM_scaleEntity 	joueurA,sc  ,sc   ,sc
	GOM_sceneObjectAll	joueurA

joueurA_run		= LoadAnimSeq(joueura,"media\mak_running.3ds")

	gom_Animate		joueurA,1,1,joueurA_run

RotateEntity	joueurA,0,-90,0		
PositionEntity  joueurA,0,-(hjoueur/2.0)+0.5,0

; camera	------------------------------------------------------------------------------- GOM
		camera			= GOM_CreateCamera()
		GOM_CameraRange camera,.01,1000
	
PositionEntity 	camera,0,30,-60
PointEntity		camera,scene 


; improve performance and clean parasite shadow ---------------------------------------- GOM

GOM_shadowNO(scene2b,scene2)
GOM_shadowNO(scene2,scene2b)
GOM_shadowNO(cyl1,scene2)
GOM_shadowNO(cyl1,scene2b)
GOM_shadowNO(cyl2,scene2)
GOM_shadowNO(cyl2,scene2b)
GOM_shadowNO(cyl3,scene2)
GOM_shadowNO(cyl3,scene2b)
GOM_shadowNO(scene2b,cyl1)
GOM_shadowNO(scene2b,cyl2)
GOM_shadowNO(scene2b,cyl3)
GOM_shadowNO(scene2,cyl1)
GOM_shadowNO(scene2,cyl2)
GOM_shadowNO(scene2,cyl3)
GOM_shadowNO(joueura1,scene2b)
GOM_shadowNO(scene2b,joueura1)

; preparation -------------------------------------------------------------------------- GOM

	GOM_scenePrepare(scene ) 


; game ----------------------------------------------------------------------------------

timer1 	= MilliSecs() + 2000
mt# 	= 0.1
timer2 	= MilliSecs() + 1000
mr#		= 1
TurnEntity	sun,0,180,0
Collisions 	cjoueur,cscene,2,2

While Not KeyDown(1)
	
	
	TurnEntity	sun,0,-1,0
	TurnEntity	pivot,0,1,0	
	TurnEntity	pivot1,0,-1,0		
	MoveEntity 	joueur,0,-0.1,0
	MoveEntity 	joueur1,0,-0.1,0

	
	UpdateWorld()	
		
		
		GOM_sceneShadow(cyl1,cyl1,camera) ;--------------------------------------------- GOM

		
	RenderWorld
	
	
	Color 255,255,255
	lig = 0

	lig = lig + 20 : Text 0,sHeight-lig ,"fps=" + fps + " trisrendered=" + TrisRendered()
	lig = lig + 20 : Text 0,sHeight-lig ,"You can see the current limitation of the GOM system: multiple projected shadows on the same object"

	Flip
	
	Gosub fps
	
Wend



End

;///////////////////////////////////////////////////////////////////////////////////////////////// FUNCTIONS

.fps

	If MilliSecs() > timerFps Then 
		timerFps 	= MilliSecs() + 1000 
		FPS 			= FPSCount 
		FPSCount 		= 0 
		FPSreal 		= fRate - ftime3
	Else
		FPSCount 		= FPSCount + 1
	EndIf

Return




Function hauteurScene#(scene,x,z)

	LinePick 		(x,1000,z,0,-2000,0)

	Return PickedY()
	
End Function