; 	Title 			: program to test the SUN and LIGHT shadow 
;	Development 	: Philippe C / HautVent
;	Test 			: Philippe C / HautVent
;
;
;	test program
;
;----------------------------------------------------------------------------------------------
;		
; 
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
;
;----------------------------------------------------------------------------------------------

Global PUB	= True

Include "lib\gom_shadow----------v01-00.bb"

Const sWidth 		= 800
Const sHeight 		= 600
Const sWidthd2		= sWidth/2
Const sHeight2		= sHeight/2
Const cscene		= 1
Const cjoueur		= 2

Graphics3D 		sWidth ,sHeight,0,2

SetBuffer 		BackBuffer()
AmbientLight	255,255,255

; scene ----------------------------------------------------------------------- GOM
size = 40
		scene 			= GOM_CreateCube()
		GOM_ScaleEntity	scene, size,0.1,size
		GOM_sceneCreate	(scene,25,25,25); <= all the objects created after this ligne belong to the this scene 

EntityColor 	scene, 255,0,0
EntityType		scene,cscene
EntityPickMode 	scene, 2

; objet ------------------------------------------------------------------------------- GOM

		cyl1			= GOM_CreateCylinder()
		GOM_scaleMesh 	cyl1	 ,2  ,10    ,2
		GOM_zoomSize	(cyl1,0.01)
		GOM_shadowTime	(cyl1,10)
		GOM_sceneTitle	(cyl1,"green")
		GOM_shadowHeight(cyl1,MeshHeight(cyl1))
				
PositionEntity	cyl1,-8,9.6,0
EntityColor 	cyl1,0,255,0
ResetEntity 	cyl1
EntityType		cyl1,cscene

		cyl2			= GOM_CreateCylinder()
		GOM_scaleMesh 	cyl2	 ,2  ,10    ,2
		GOM_zoomSize	(cyl2,0.01)
		GOM_shadowTime	(cyl2,10)
		GOM_sceneTitle	(cyl2,"blue")
		GOM_shadowHeight(cyl2,MeshHeight(cyl2))

PositionEntity	cyl2,8,9.6,0
EntityColor 	cyl2,0,0,255
ResetEntity 	cyl2
EntityType		cyl2,cscene


; sun		------------------------------------------------------------------------------- GOM

sun 			= CreatePivot()
sun1			= CreateSphere(4,sun)
ysunMin 		= 25
EntityFX		sun1,1

		lightSun			= GOM_CreateLight(1,sun1)
		GOM_LightColor 		lightSun,255,255,255
		GOM_sceneTitle		(lightSun,"sun")
		GOM_LightRange		lightSun,1000
		 

PositionEntity 	sun1,0,25,40,True
EntityColor 	sun1,255,255,255
PointEntity 	lightSun,scene


; player 	------------------------------------------------------------------------------- GOM

sc#				= 0.2
p 				= LoadMesh("media\mak_robotic.3DS")
hjoueur#		= MeshHeight(p)*sc
wjoueur#		= MeshDepth(p)*sc
If MeshWidth(p)*sc < wjoueur Then wjoueur = MeshWidth(p)*sc

FreeEntity		p
pivot			= CreatePivot()
joueur			= CreatePivot(pivot)
EntityRadius 	joueur,wjoueur,(hjoueur/2.0)
PositionEntity 	joueur,0,hjoueur/2,15
EntityType		joueur,cjoueur
ResetEntity 	joueur

	joueurA				= GOM_LoadAnimMesh("media\mak_robotic.3DS",joueur)
	GOM_shadowHeight	(joueurA,hjoueur)
	GOM_sceneTitle		(joueurA,"robot")
	GOM_shadowTime		(joueurA,10)
	GOM_scaleEntity 	joueurA,sc  ,sc   ,sc
	GOM_sceneObjectAll	joueurA

joueurA_run		= LoadAnimSeq(joueura,"media\mak_running.3ds")

	gom_Animate		joueurA,1,1,joueurA_run

RotateEntity	joueurA,0,-90,0		
PositionEntity  joueurA,0,-(hjoueur/2.0)+0.5,0


; camera	------------------------------------------------------------------------------- GOM
		camera			= GOM_CreateCamera()
		GOM_CameraRange camera,.01,1000
	
PositionEntity 	camera,0,20,-60
PointEntity		camera,scene 



; preparation -------------------------------------------------------------------------- GOM

	GOM_scenePrepare(scene ) 


; game ----------------------------------------------------------------------------------

timer1 	= MilliSecs() + 2000
mt# 	= 0.1
timer2 	= MilliSecs() + 1000
mr#		= 1
TurnEntity	sun,0,180,0
Collisions 	cjoueur,cscene,2,2

While Not KeyDown(1)
	
	
	TurnEntity	sun,0,-1,0
	TurnEntity	pivot,0,1,0		
	MoveEntity 	joueur,0,-0.1,0
	
	UpdateWorld()	
		
		
		GOM_sceneShadow(cyl1,cyl1,camera) ;--------------------------------------------- GOM

		
	RenderWorld
	
	
	Color 255,255,255
	lig = 0

	lig = lig + 20 : Text 0,sHeight-lig ,"fps=" + fps + " trisrendered=" + TrisRendered()
	
	Flip
	
	Gosub fps
	
Wend



End

;///////////////////////////////////////////////////////////////////////////////////////////////// FUNCTIONS

.fps

	If MilliSecs() > timerFps Then 
		timerFps 	= MilliSecs() + 1000 
		FPS 			= FPSCount 
		FPSCount 		= 0 
		FPSreal 		= fRate - ftime3
	Else
		FPSCount 		= FPSCount + 1
	EndIf

Return




Function hauteurScene#(scene,x,z)

	LinePick 		(x,1000,z,0,-2000,0)

	Return PickedY()
	
End Function