; 	Title 			: program to test the SUN and LIGHT shadow 
;	Development 	: Philippe C / HautVent
;	Test 			: Philippe C / HautVent
;
;
;	test program
;
;----------------------------------------------------------------------------------------------
;		
; 
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
;
;----------------------------------------------------------------------------------------------

Global PUB	= True

Include "lib\gom_shadow----------v01-00.bb"

Const sWidth 		= 800
Const sHeight 		= 600
Const sWidthd2		= sWidth/2
Const sHeight2		= sHeight/2
Const cscene		= 1
Const cjoueur		= 2

Graphics3D 		sWidth ,sHeight,0,2

SetBuffer 		BackBuffer()


; scene ----------------------------------------------------------------------- GOM
size = 20
		scene 			= GOM_CreateCube()
		GOM_ScaleEntity	scene, size,0.1,size
		GOM_sceneCreate	(scene,25,25,25); <= all the objects created after this ligne belong to the this scene 
	
EntityPickMode 	scene, 2
EntityColor 	scene, 255,0,0


; objet ------------------------------------------------------------------------------- GOM

		tree			= GOM_CreateCylinder()
		GOM_scaleMesh 	tree	 ,2  ,5    ,2
		GOM_zoomSize	(tree,0.014)
		GOM_shadowTime	(tree,10)
		
PositionEntity	tree,0,4.6,0

EntityColor 	tree,0,255,0


; sun	------------------------------------------------------------------------------- GOM

sun 			= CreatePivot()
sun1			= CreateSphere(4,sun)
ysunMin 		= 25
EntityFX		sun1,1

		lightSun			= GOM_CreateLight(1,sun1)
		GOM_LightColor 		lightSun,255,255,255
		GOM_sceneTitle		(lightSun,"sun")
		GOM_LightRange		lightSun,1000
		 

PositionEntity 	sun1,0,20,10,True
EntityColor 	sun1,255,255,255
PointEntity 	lightSun,scene

; camera	------------------------------------------------------------------------------- GOM
		camera			= GOM_CreateCamera(joueur)
		GOM_CameraRange camera,.01,1000
	
PositionEntity 	camera,0,10,-30
PointEntity		camera,scene 

; preparation -------------------------------------------------------------------------- GOM

	GOM_scenePrepare(scene ) 


; game ----------------------------------------------------------------------------------
timer1 	= MilliSecs() + 2000
mt# 	= 0.1
timer2 	= MilliSecs() + 1000
mr#		= 1

While Not KeyDown(1)
	
	
	TurnEntity	sun,0,1,0
	
	If timer1 < MilliSecs()
		If EntityX(tree) > size/2 Then mt = -1*mt
		If EntityX(tree) < -size/2 Then mt = -1*mt

		PositionEntity tree,EntityX(tree) + mt,EntityY(tree),0
	EndIf
	
	If timer2 < MilliSecs()
		RotateEntity tree,0,0,EntityRoll(tree)+mr
	EndIf
	
	
	UpdateWorld()	
		
		
		GOM_sceneShadow(tree,tree,camera) ;--------------------------------------------- GOM

		
	RenderWorld
	
	
	Color 255,255,255
	lig = 0

	lig = lig + 20 : Text 0,sHeight-lig ,"fps=" + fps + " trisrendered=" + TrisRendered()
	
	Flip
	
	Gosub fps
	
Wend



End

;///////////////////////////////////////////////////////////////////////////////////////////////// FUNCTIONS

.fps

	If MilliSecs() > timerFps Then 
		timerFps 	= MilliSecs() + 1000 
		FPS 			= FPSCount 
		FPSCount 		= 0 
		FPSreal 		= fRate - ftime3
	Else
		FPSCount 		= FPSCount + 1
	EndIf

Return




Function hauteurScene#(scene,x,z)

	LinePick 		(x,1000,z,0,-2000,0)

	Return PickedY()
	
End Function