/*
Copyright (c) 2009 David Bucciarelli (davibu@interfree.it)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <stdio.h>
#include <stdlib.h>

#define MAX_WIDTH 1920
#define MAX_HEIGHT 1200
#define FRAME_SEC 25.f

// A fast hack to decode move.bin

//# Pass 1: rm divx2pass.log ; mencoder mf://frame*.ppm.png -vf hqdn3d=2:1:2 -mf w=640:h=480:fps=25:type=png -ovc lavc -lavcopts vcodec=mpeg4:vpass=1:mbd=2:trell:vbitrate=3000 -oac copy -o /dev/null
//# Pass 2: mencoder mf://frame*.ppm.png -vf hqdn3d=2:1:2 -mf w=640:h=480:fps=25:type=png -ovc lavc -lavcopts vcodec=mpeg4:vpass=2:mbd=2:trell:vbitrate=3000 -oac copy -o output.avi
//# for i in `ls frame*.ppm`; do echo $i; convert $i -fill white -gravity SouthEast -pointsize 16 -annotate +0+0 'SmallPT GPU\nWritten by David Bucciarelli' tmp.png; mv tmp.png $i.png; done

static void WriteFrame(int frame, int frameWidth, int frameHeight, unsigned int *sourceFrame) {
	char fileName[128];
	sprintf(fileName, "frame%06d.ppm", frame);
	FILE *frameFile = fopen(fileName, "wb");

	fprintf(frameFile, "P6\n# Frame %d\n%d %d\n255\n", frame, frameWidth, frameHeight);
	int y;
	for (y = 0; y < frameHeight; ++y) {
		unsigned int *p = &sourceFrame[(frameHeight - y -1) * frameWidth];

		int x;
		for (x = 0; x < frameWidth; ++x)
			fwrite(p++, sizeof (unsigned char), 3, frameFile);
	}

	fclose(frameFile);
}

int main(int argc, char *argv[]) {
	fprintf(stderr, "Usage: %s\n", argv[0]);
	fprintf(stderr, "Decoding movie.bin file\n");

	// Open the movie file
	FILE *movieFile = fopen("movie.bin", "rb");
	if (movieFile == NULL) {
		fprintf(stderr, "Failed to open movie file: movie.bin\n");
	}

	float currentTime = 0.f;
	int frame;
	unsigned int *sourceFrame = (unsigned int*) malloc(sizeof(unsigned int)*MAX_WIDTH * MAX_HEIGHT);
	for (frame = 0; !feof(movieFile);) {
		float frameTime;
		int res = fread(&frameTime, sizeof(float), 1, movieFile);
		int frameWidth;
		res = fread(&frameWidth, sizeof(int), 1, movieFile);
		int frameHeight;
		res = fread(&frameHeight, sizeof(int), 1, movieFile);

		fprintf(stderr, "Source frame size: %dx%d (%f)\n", frameWidth, frameHeight, frameTime);
		if ((frameWidth * frameHeight) > (MAX_WIDTH * MAX_HEIGHT)) {
			fprintf(stderr, "Frame %d is too big: %dx%d\n",frame, frameWidth, frameHeight);
			exit(-1);
		}

		res = fread(sourceFrame, sizeof(unsigned int), frameWidth * frameHeight, movieFile);

		if (frame == 0) {
			currentTime = frameTime;
			fprintf(stderr, "Writing first frame, time: %f\n", currentTime);
			WriteFrame(frame++, frameWidth, frameHeight, sourceFrame);
		} else {
			while (currentTime < frameTime) {
				fprintf(stderr, "Writing frame %d with time: %f\n", frame, currentTime);

				WriteFrame(frame++, frameWidth, frameHeight, sourceFrame);
				currentTime += 1.f / currentTime;
			}
		}
	}

	fclose(movieFile);

	return 0;
}
