#pragma once

namespace bParse {
	class bBlenderFile;
}

///Ray mirror property of mode and mode_l of material - reflection.
#define RAY_MIRROR 0x40000
///Ray transp property of mode and mode_l of material - refraction.
#define RAY_TRANSP 0x20000


////////////////////////////////////////////////////////////////////////////////////////////////////
/// @enum	BlenderErrors
///
/// @brief	Values of errors returned by Blender Parser. 
////////////////////////////////////////////////////////////////////////////////////////////////////
enum BlenderErrors{
	kOk = 0,
	kParsingFailed = -1,
	kNoMain = -2,
	kNoScene = -3,
	kEmptyScene = -4
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// @enum	ObjectTypes
///
/// @brief	Values that represent types of objects in blender. 
////////////////////////////////////////////////////////////////////////////////////////////////////

enum ObjectTypes{
	ObjectMesh=1,
	ObjectCamera=11,
	ObjectLight=10
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// @class	CBlenderReader
///
/// @brief	Blender reader. 
///
/// Used for reading blender files and converting to compatible scene format.
/// @author	Lukasz Kwoska
/// @date	2009-12-19
////////////////////////////////////////////////////////////////////////////////////////////////////
class CBlenderReader
{
public:
	CBlenderReader(void);
	~CBlenderReader(void);

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// @fn	int ReadFile(const char* FileName)
	///
	/// @brief	Reads a blender file. 
	///
	/// @author	Lukasz Kwoska
	/// @date	2009-12-19
	///
	/// @param [in]	FileName	Filename of the blender file to read. 
	///
	/// @return	if ok then kOk, otherwise another from BlenderErrors . 
	////////////////////////////////////////////////////////////////////////////////////////////////////
	int ReadFile(const char* FileName);

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// @fn	Sphere* GenerateScene()
	///
	/// @brief	Generates a scene from already read blend file. 
	///
	/// @author	Szaq
	/// @date	2009-12-19
	///
	/// @param [out] GeneratedSpheres Number of generated spheres.
	/// @param [out] SceneCamera First camera from the blend file.
	///
	/// @return	null if it fails, else the scene. 
	////////////////////////////////////////////////////////////////////////////////////////////////////
	Sphere* GenerateScene(unsigned int &GeneratedSpheres, Camera &SceneCamera);

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// @fn	int GetLastError()
	///
	/// @brief	Gets error from last operation. 
	///
	/// @author	Lukasz Kwoska
	/// @date	2009-12-19
	///
	/// @return	The last error. 
	////////////////////////////////////////////////////////////////////////////////////////////////////
	int GetLastError();
private:
	///Blender file used for generating scene.
	bParse::bBlenderFile *m_File;
	//Error from last operation.
	int m_LastError;
};
