/***************************************************************************

 Copyright (C) 2007  Sergey Prokhorchuk

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***************************************************************************/

#ifndef __P3DPLUGINFO_H__
#define __P3DPLUGINFO_H__

#include <string>
#include <vector>

#include <ngpcore/p3diostream.h>

enum
 {
  P3DPluginTypeModelExport = 0,
  P3DPluginTypeGMeshGenerator
 };

class P3DPluginInfo
 {
  public           :

                   P3DPluginInfo      ();

  bool             LoadInfo           (P3DInputStringStream
                                                          *SourceStream,
                                       const char         *FileName);

  unsigned int     GetType            () const;
  const char      *GetMenuName        () const;
  const char      *GetFileName        () const;

  private          :

  unsigned int     Type;
  std::string      MenuName;
  std::string      FileName;
 };

typedef std::vector<P3DPluginInfo>     P3DPluginInfoVector;

#endif

