#!BPY

"""
Name: 'BVH Motion Capture'
Blender: 233
Group: 'Import'
Tip: 'Import a (*.bvh) motion capture file'
"""
######################################################
# BVH Importer
# By:  Bob Holcomb
# Date: 29 MAY 04
# Ver: 0.1
######################################################
#
######################################################

import string
import math
import Blender
from Blender import *



class joint_info:
	root=0
	name=""
	parent_name=""
	channel=[]
	num_channels=0
	offset=[]
	location=[]
	bone_list=[]
	
	def __init__(self):
		self.root=0
		self.name=""
		self.parent_name=""
		self.channel=[-1]*6
		self.num_channels=0
		self.offset=[0.0]*3
		self.location=[0.0]*3
		self.bone_list=[]
		
	def dump(self):
		print "root: ", self.root
		print "name: ", self.name
		print "parent  name: ", self.parent_name
		print "channels: ", self.channels
		print "num_channels: ", self.num_channels
		print "offset: ", self.offset
		print "location: ", self.location
		print "bone list: ", self.bone_list



#===============================================#
# MAIN FUNCTION - All things are done from here #
#===============================================#
def loadBVH(filename):
	joint_stack=[]
	joint_list=[]
	joint_lookup={}
	end_branch=False
	closure_counter=0
	
	#create a root joint
	base_joint=joint_info()
	base_joint.name="Root"
	base_joint.location=(0,1,0)
	base_joint.offset=(0,0,0)
	
	#add the root joint to the lists
	joint_stack=[base_joint]
	joint_lookup[base_joint.name]=base_joint

	print ""
	print "BVH Importer 0.1 by Bob Holcomb, base heavily on bvh_import.py by Campbell Barton (Ideasman) - ideasman@linuxmail.org"

	# Open the file for importing
	file = open(filename, 'r')  
	fileData = file.readlines()
	# Make a list of lines
	lines = []
	for fileLine in fileData:
		newLine = string.split(fileLine)
		if newLine != []:
			lines.append(string.split(fileLine))
		fileData = None
	# End file loading code
	
  
	# Create Hirachy as armature
	if lines[0][0] == 'HIERARCHY':
		print 'Importing the BVH Hierarchy for:', filename
	else:
		return 'ERROR: This is not a BVH file'

	#create the armature
	armObj = Object.New('Armature', "Armature_obj")
	armData = Armature.New()
	
				
	#setup channel stuff
	channel_index = -1
	
	line_index = 1 # An index for the file.
	while line_index < len(lines) -1:	
		#read joint
		if lines[line_index][0] == 'ROOT' or lines[line_index][0] == 'JOINT': 
			print "--------Found a Joint----------"
			
			#create a new joint
			new_joint=joint_info()
			
			#name it
			new_joint.name=lines[line_index][1]
			
			#get to the offset
			line_index+=2
			new_joint.offset = ( eval(lines[line_index][1]), eval(lines[line_index][2]), eval(lines[line_index][3]) )

			#set the parent
			new_joint.parent_name=joint_stack[-1].name
			
			#compute location
			if new_joint.parent_name!="Root":
				p=joint_lookup[new_joint.parent_name]
				new_joint.location[0]=new_joint.offset[0]+p.location[0]
				new_joint.location[1]=new_joint.offset[1]+p.location[1]
				new_joint.location[2]=new_joint.offset[2]+p.location[2]
			else:
				new_joint.location[0]=new_joint.offset[0]
				new_joint.location[1]=new_joint.offset[1]
				new_joint.location[2]=new_joint.offset[2]
			
			line_index += 1 # Incriment to the next line (Channels)
			
			#load the channel information up
			for channel in lines[line_index][2:]:
				channel_index += 1 # So the index points to the right channel
				if channel == 'Xposition':
					new_joint.channel[0] = channel_index
				if channel == 'Yposition':
					new_joint.channel[1] = channel_index
				if channel == 'Zposition':
					new_joint.channel[2] = channel_index
				if channel == 'Xrotation':
					new_joint.channel[3] = channel_index
				if channel == 'Yrotation':
					new_joint.channel[4] = channel_index
				if channel == 'Zrotation':
					new_joint.channel[5] = channel_index
			
			
			new_joint.num_channels=lines[line_index][2:]
			
			#push it on stacks
			joint_stack.append(new_joint)
			
			#if not first joint
			j1=joint_stack[-2]
			j2=joint_stack[-1]
			
			if (j1!=None and j2!=None):
				#build a bone
				b=Blender.Armature.Bone.New(j2.name)
				b.setHead(j1.location)
				b.setTail(j2.location)
				print "created bone: ", j2.name
				
				#setup the parent of the bone
				if j1.parent_name!="":
					#get all the existing bones
					p_list=armData.getBones()
					for p in p_list:
						#if the bone is the same name as the parent
						if p.getName()==j2.parent_name:
							b.setParent(p)
							print "Set the parent to: ",  j2.parent_name
				armData.addBone(b)
			
			#because BVH is joint based and blender bone based, the joints actually influence thier children, not the bone they are named after
				
			#add the bone to the parents influence list
			if j1.parent_name=="Root":
				j1.bone_list.append(j1.name)
			j1.bone_list.append(j2.name)
	
			#add the joint to the lists
			joint_lookup[new_joint.name]=new_joint
			joint_list.append(new_joint)
		
			print len(joint_stack) * '  ' + 'joint:',new_joint.name,' parent:',new_joint.parent_name
			
		if lines[line_index][0] == 'End' and lines[line_index][1] == 'Site':
			#print "--------Found an End Joint----------"
			#create a new joint
			new_joint=joint_info()
			
			new_joint.name=joint_stack[-1].name+"_end"
			
			#get to the offset
			line_index+=2
			new_joint.offset = ( eval(lines[line_index][1]), eval(lines[line_index][2]), eval(lines[line_index][3]) )

			#set the parent
			new_joint.parent_name=joint_stack[-1].name
			
			#compute location
			p=joint_lookup[new_joint.parent_name]
			new_joint.location[0]=new_joint.offset[0]+p.location[0]
			new_joint.location[1]=new_joint.offset[1]+p.location[1]
			new_joint.location[2]=new_joint.offset[2]+p.location[2]
			
			#push it on stack
			joint_stack.append(new_joint)
			
			#if not first joint
			j1=joint_stack[-2]
			j2=joint_stack[-1]
			
			if (j1!=None and j2!=None):
				#build a bone
				b=Blender.Armature.Bone.New(j2.name)
				b.setHead(j1.location)
				b.setTail(j2.location)
				print "created bone: ", j2.name
				
				#setup the parent of the bone
				if j1.parent_name!="":
					#get all the existing bones
					p_list=armData.getBones()
					for p in p_list:
						#if the bone is the same name as the parent
						if p.getName()==j2.parent_name:
							b.setParent(p)
							print "Set the parent to: ",  j2.parent_name
				armData.addBone(b)
			
			#because BVH is joint based and blender bone based, the joints actually influence thier children, not the bone they are named after
				
			#add the bone to the parents influence list
			j1.bone_list.append(j2.name)
			joint_lookup[new_joint.name]=new_joint
			
			print len(joint_stack) * '  ' + 'joint:',new_joint.name,' parent:',new_joint.parent_name

			
		if lines[line_index][0]=='}':
			#pop off joint off stack
			joint_stack=joint_stack[:-1]

		line_index+=1
	
	#add the armature (with bones) to blender
	#armData.drawNames(1)
	armObj.link(armData)

	scn = Blender.Scene.getCurrent()
	scn.link(armObj)

	armObj.makeDisplayList()
	Blender.Window.RedrawAll()
	
	#time for motion data 
	
	line_index = 1 # An index for the file.
	while line_index < len(lines) -1:
		if lines[line_index][0] == 'MOTION': 
			print '\nImporting motion data'
			line_index += 1 # Set the cursor to the forst frame
			if lines[line_index][0]=="Frames:":
				num_frames= eval(lines[line_index][1])
				print "number of frames: ", num_frames
			
			line_index+=1
			if lines[line_index][0]=="Frame" and lines[line_index][1]=="Time:":
				frame_time= eval(lines[line_index][2])
				print "frame_time: ", frame_time
			
			#get the bone this joint will manipulate
			p_list=armData.getBones()
			
			for frame in range (0,num_frames):
				#set the current frame
				Blender.Set("curframe", frame)
				line_index+=1
				
				#for each joint
				for joint in joint_list:
					#for each bone that joint influences
					for b in joint.bone_list:
						#except the root joint
						if joint.parent_name=="Root":
							for p in p_list: 
								if p.getName()==joint.name:
									#print "Just the root bone gets moved/rotated on the root joint"
									break
						else:
							#set p to the bone
							for p in p_list:
								#if the bone is the same name as the joint.name
								if p.getName()==b:
									#print "joint: ", joint.name, "influences bone: ",b 
									#break out of this loop and do the calculations
									break
						x=0.0
						y=0.0
						z=0.0
						rx=0.0
						ry=0.0
						rz=0.0
						move=False
						rot=False
						
						#get info for each channel
						if joint.channel[0]!=-1:
							x=eval(lines[line_index][joint.channel[0]])
							move=True
						if joint.channel[1]!=-1:
							y=eval(lines[line_index][joint.channel[1]])
							move=True
						if joint.channel[2]!=-1:
							z=eval(lines[line_index][joint.channel[2]])
							move=True
						if joint.channel[4]!=-1:
							rx=eval(lines[line_index][joint.channel[3]])
							rxmat=Blender.Mathutils.RotationMatrix(-rx,4,'x')
							rot=True
						if joint.channel[4]!=-1:
							ry=eval(lines[line_index][joint.channel[4]])
							rymat=Blender.Mathutils.RotationMatrix(-ry,4,'y')
							rot=True
						if joint.channel[5]!=-1:
							rz=eval(lines[line_index][joint.channel[5]])
							rzmat=Blender.Mathutils.RotationMatrix(rz,4,'z')
							rot=True
					
						#actually more the data for that bone
						#this makes it line up nicely with the original BVH import script for some reason
						if move==True:
							p.setLoc(-x,-y,z)
						if rot==True:
							#not working right, I suck
							comb_mat=Blender.Mathutils.Matrix()
							comb_mat.resize4x4()
							comb_mat.identity()
							comb_mat=comb_mat*rymat
							comb_mat=comb_mat*rzmat
							comb_mat=comb_mat*rxmat
							p.setQuat(comb_mat.toQuat())
							
						
						#reset the flags
						move=False
						rot=False
				
						p.setPose([Blender.Armature.Bone.ROT,Blender.Armature.Bone.LOC,Blender.Armature.Bone.SIZE]) 

				print "Updated Frame #: ", frame
				
		line_index+=1
	
	
	
	
	
loadBVH("/home/bob/blender/scripts/01flap.bvh")
#Blender.Window.FileSelector(loadBVH)