Include "Cube_Reflection01.bb"

Graphics3D 800,600,32,2
SetBuffer BackBuffer()

;
; Prepare stuff
Cube_Init()

;
; Make a camera
Global camera=CreateCamera()
CameraClsMode camera,False,True
CameraRange camera,1,10000
CameraFogColor camera,96,140,183
CameraFogRange camera,2000,9000
CameraFogMode camera,1

;
; Make a stunning light
light=CreateLight()
RotateEntity light,25,0,0
AmbientLight 100,105,120

;
; Make a pivot which the camera points at
center=CreatePivot()

;
; Make a sky sphere
skytex = LoadTexture("sky.png",1+8+16+32)
sky = CreateSphere(16)
FlipMesh sky
ScaleEntity sky,5000,5000,5000
EntityOrder sky,1000
EntityFX sky,1+16
EntityTexture sky,skytex

;
; A duck
duck=LoadMesh("RubberDuck00.3ds")
ScaleEntity duck,100,100,100


;
; Some great variables
size# = 128*50.0
a#=180
storm# = 1.0
height# = 10.0
crystal# = 0.6
Animat = True
cubeupd = True
help = True

;
; And then we are ready
While KeyDown(1)=0
	
	sx# = MouseXSpeed()
	sy# = MouseYSpeed()
	
	a2# = (a2+.01) Mod 360
	
	;
	; Animate camera or control it with mouse + keys
	If animat
		a#=(a+.1) Mod 360
		PositionEntity camera, Sin(a)*(.5*size),500+(Sin(a)*400),Cos(a)*(.5*size)
		PointEntity camera, center
	Else
		TurnEntity camera,sy,-sx,0
		RotateEntity camera,EntityPitch(camera,True),EntityYaw(camera,True),0
		MoveEntity camera,(KeyDown(32)-KeyDown(30))*10,0,(KeyDown(17)-KeyDown(31))*10
	EndIf
	
	;
	; Move the duck
	x# = Sin(-a2)*5000.0
	z# = Cos(-a2)*5000.0
	y# = Cube_GetHeight(x,z)
	PositionEntity duck,x,y,z
	
	Cube_GetSlope(x,z)
	RotateEntity duck,0,0,0
	AlignToVector duck,slope_x,slope_y,slope_z,2
	TurnEntity duck,0,a2-90,0
	
	;
	; Change fog if below water level
	If EntityY(camera,True)<0
		CameraFogColor camera,50,90,100
		CameraFogRange camera,500,3000
	Else
		CameraFogColor camera,96,140,183
		CameraFogRange camera,2000,9000
	EndIf
	
	;
	; Reposition sky
	PositionEntity sky,EntityX(camera,1),EntityY(camera,1),EntityZ(camera,1),1

	;
	; Animate the waves
	Cube_Waves(camera,storm,height,crystal)
	
	;
	; Update reflection?
	If cubeupd
		Cube_Update(camera,sky)
	EndIf

	RenderWorld()

	;
	; 3 - Toggle Reflection Update 
	If KeyHit(4)
		cubeupd = Not cubeupd
	EndIf
	
	;
	; Arrow Up/Down - Wave Speed
	If KeyHit(200)
		storm = storm + 0.1
	ElseIf KeyHit(208)
		storm = storm - 0.1
		If storm<0 Then storm = 0 
	EndIf

	;
	; Arrow Left/Right - Wave Height
	If KeyDown(203)
		height = height - 0.1
		If height<0 Then height = 0
	ElseIf KeyDown(205)
		height = height + 0.1
	EndIf
	
	;
	; 1/2 - Reflection Intensity
	If KeyHit(3)
		crystal = crystal+0.1
		If crystal>1.0 Then crystal = 1.0
	ElseIf KeyHit(2)
		crystal = crystal-0.1
		If crystal<0.1 Then crystal = 0.1
	EndIf
	
	;
	; Space - Toggle Animation
	If KeyHit(57)
		animat = Not animat
	EndIf

	;
	; F1 - Hide Help
	If KeyHit(59) Then help = Not help
	
	If help
		Text 0,0,"Arrow Up/Down - Wave Speed ("+storm+") | Arrow Left/Right - Wave Height ("+height+") | Space - Toggle Animation"
		Text 0,10,"1/2 - Reflection Intensity ("+crystal+") | 3 - Toggle Reflection Update ("+cubeupd+") | ASWD + Mouse - Move"
		Text 0,20,"F1 - Hide Help"
		Text 0,30,curFPS+"FPS"
	EndIf
	
	;
	; Fps counter	
	curTime = MilliSecs()
	If curTime > checkTime Then
		checkTime = curTime + 1000
		curFPS = fpscounter
		fpscounter = 0
		If currentFrame>75
			If curFPS<fps_low Then fps_low = curFPS
		EndIf
	Else
		fpscounter = fpscounter + 1
	End If
	
	Flip False
Wend

;
; We're done!
End