Global FXCamera,CubeLightMapSize,CubeLightMapTexture,WaterMapSize,WaterMapTexture,waterdirection
Global camera,ball,level,campitch#,camyaw#,mvx#,mvy#,mvz#,DummyTexure,water,r#
Global turn,sprite,underwater,tab,player,firesprite,detail,floorpivot
Global fpsindex#,fpstime#,fpsfold_millisecs#,fpsfps#,wdb,wasunderwater,oldpicked
Global lcount=0


CubeLightMapSize = 256 ; the resolution of the dynamic lightmap *not used in this demo*
WaterMapSize = 256 ; the resolution of the water

Const C_level=1,C_player=2,C_floorpivot=3

Type layer
	Field mesh
	Field count
	Field spritebank ; pointer to a type just for holding a list of sprites
	Field emptybank  ; points to bank positions that are empty for filling
End Type

Type sprite
	Field x#,y#,z#,s#,a#
	Field vx#,vy#,vz#,vs#,va#
	Field r,g,b,vr#,vg#,vb#
	Field gravity#
	Field verti[3]
	Field surf,mesh,spawntype
	Field life
End Type


Type deletelist
	Field ent,x#,y#,z#
End Type

Type bumptexture
	Field filename$
End Type

;----------------------------------------------------------------------------------

Global info1$="Cube mapped water effect"
Global info2$="Mouse to look around, W/A/S/Z to move"

Graphics3D 640,480,16,2


AmbientLight 255,255,255

player=CreatePivot()
floorpivot=CreatePivot()
camera=CreateCamera(player)


MoveEntity camera,0,1.2,0
PositionEntity player,-52,8,353



FXCamera=CreateCamera()
CameraClsMode FXCamera,False,True
CameraProjMode FXCamera,0
CameraViewport FXCamera,0,0,WaterMapSize,WaterMapSize



;SET UP LEVEL
level = LoadAnimMesh("level/test.b3d")


; SET UP WATER - load a reference mesh 

water=LoadMesh("level/water.3ds")
MoveEntity water,0,-2,0
WaterMapTexture=CreateTexture(WaterMapSize,WaterMapSize,128+256+48)
EntityTexture water,WaterMapTexture
EntityColor water,100,200,255
EntityColor water,512,512,512
EntityAlpha water,0.7
EntityFX water,1

AddEntity(water)

Type Vertices
	Field x#
	Field y#
	Field z#
End Type
surf=GetSurface(water,1)
Dim Vertex.Vertices(CountVertices(surf))
For i=0 To CountVertices(surf)-1
	Vertex(i) = New Vertices
	Vertex(i)\x#=VertexX#(surf,i)
	Vertex(i)\y#=VertexY#(surf,i)
	Vertex(i)\z#=VertexZ#(surf,i)
Next



;----------------------------------------------------------------------------------

Collisions c_player,c_level,2,2
EntityType player,c_player
EntityType floorpivot,c_player

EntityType level,c_level,1
EntityRadius player,4.5,6
EntityRadius floorpivot,4
;----------------------------------------------------------------------------------


cubo=LoadAnimMesh ("level/cubo.b3d")
;MAINLOOP

While Not KeyHit(1)
	db=1-db
	FreeLook()
	RenderWater()
	UpdateNormals water		

	
	glow#=Cos(MilliSecs())
	lum#=(Abs(glow*Sin(glow))*255)*0.8
	UpdateWorld
	RenderWorld
	
	Flip
Wend
End





;--------------------------------------------------------------------------------------------
Function CreateLayer()
	l.layer=New layer	
	l\mesh=CreateMesh() : surf=CreateSurface(l\mesh)
	l\spritebank=CreateBank()
	NameEntity l\mesh,Handle(l)
	EntityColor l\mesh,255,255,255
	EntityFX l\mesh,1+2
	EntityBlend l\mesh,3
	Return l\mesh
End Function
;--------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------

;----------------------------------------------------------------------------------

Function RenderWater()


	CameraProjMode camera,0
	CameraProjMode FXCamera,1
	
	wdb=1-wdb
		
	
	;flip water if under it
				
	If underwater=0	
		If waterdirection=-1
			FlipMesh water
			EntityAlpha water,.7
			EntityColor water,255,255,255
		EndIf
		waterdirection=1
		
		PositionEntity FXCamera,EntityX(player),EntityY(water)-2,EntityZ(player)

		
		
		If wdb
			;do left view	
			SetCubeFace WaterMapTexture,0
			RotateEntity FXCamera,0,90,0
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
			;do forward view
			SetCubeFace WaterMapTexture,1
			RotateEntity FXCamera,0,0,0
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
		Else
			;do right view	
			SetCubeFace WaterMapTexture,2
			RotateEntity FXCamera,0,-90,0
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
			;do backward view
			SetCubeFace WaterMapTexture,3
			RotateEntity FXCamera,0,180,0
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
		EndIf
		;do up view
		SetCubeFace WaterMapTexture,4
		RotateEntity FXCamera,-90,0,0
		RenderWorld
		CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
	
	Else
		If waterdirection=1
			FlipMesh water
			EntityAlpha water,1
			EntityColor water,155,200,255

		EndIf	
		waterdirection=-1
		
		PositionEntity FXCamera,-EntityX(player),EntityY(player)-2,EntityZ(player)
		
		
		If wdb
			;do left view	
			SetCubeFace WaterMapTexture,0
			RotateEntity FXCamera,0,-90,180
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
			;do forward view
			SetCubeFace WaterMapTexture,1
			RotateEntity FXCamera,0,0,180
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
		Else
			;do right view	
			SetCubeFace WaterMapTexture,2
			RotateEntity FXCamera,0,90,180
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
			;do backward view
			SetCubeFace WaterMapTexture,3
			RotateEntity FXCamera,0,180,180
			RenderWorld
			CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
		EndIf
		
		;do down view
		SetCubeFace WaterMapTexture,5
		RotateEntity FXCamera,-90,0,180
		RenderWorld
		CopyRect 0,0,WaterMapSize,WaterMapSize,0,0,BackBuffer(),TextureBuffer(WaterMapTexture)
	EndIf



	CameraProjMode FXCamera,0
	CameraProjMode camera,1
	ShowEntities()


	s=GetSurface(water,1)
	For i=0 To CountVertices(s)-1
		Freq#=MilliSecs()/4
		Vertex(i)\y#=Sin(freq+Vertex(i)\x#*500+Vertex(i)\z#*300)*1.2
		VertexCoords s,i,Vertex(i)\x#,-Vertex(i)\y#,Vertex(i)\z#
	Next

	If EntityY(camera,1)<-2 underwater=1 Else underwater=0

	If underwater
		CameraFogColor camera,50,100,155
		t#=MilliSecs()/6
		ScaleEntity camera,1+Cos(t)*0.04,1+Sin(t)*0.04,1+Cos(t)*0.02
		CameraFogRange camera,0,200+Sin(MilliSecs()*0.05)*60
		TurnEntity player,0,0,Sin(t)*2
	Else
		CameraFogColor camera,100,200,255
		ScaleEntity camera,1,1,1
		CameraFogRange camera,100,1000
	EndIf
	
End Function

;----------------------------------------------------------------------------------

Type entity
	Field ent
End Type

Type level
	Field ent
End Type

Type cubelight
	Field ent,r,g,b,radius
End Type

;----------------------------------------------------------------------------------
Function AddEntity(ent)
	e.entity=New entity
	e\ent=ent
End Function

;----------------------------------------------------------------------------------


;----------------------------------------------------------------------------------
Function ShowEntities()
	For e.entity=Each entity
		ShowEntity e\ent
	Next
End Function
;----------------------------------------------------------------------------------



Function freelook()

	mxspd#=MouseXSpeed()*0.25
	myspd#=MouseYSpeed()*0.25
	
	If underwater
		mxspd=mxspd*0.6
		myspd=myspd*0.6
	EndIf
	
		
	MoveMouse GraphicsWidth()/2,GraphicsHeight()/2

	campitch=campitch+myspd
	If campitch<-85 Then campitch=-85
	If campitch>85 Then campitch=85
	RotateEntity player,campitch,EntityYaw(player)-mxspd,0
	
	If KeyDown(203) Then mvx=mvx-.3
	If KeyDown(205) Then mvx=mvx+.3
	If KeyDown(200) Then mvz=mvz+.3
	If KeyDown(208) Then mvz=mvz-.3
	
	If KeyDown(30) Then mvx=mvx-.3
	If KeyDown(32) Then mvx=mvx+.3
	If KeyDown(17) Then mvz=mvz+.3
	If KeyDown(31) Then mvz=mvz-.3
	
	
	PositionEntity floorpivot,EntityX(player),EntityY(player)-8,EntityZ(player)
	
	If underwater
	
		mvx=mvx/1.2
		mvy=mvy-0.005
		mvz=mvz/1.2
		wasunderwater=1
	
	Else
		
		mvy=mvy-0.2
		If EntityCollided(floorpivot,c_level)
			mvy=mvy+0.2
		EndIf
		
		If wasunderwater
			wasunderwater=0
			mvy=4
		EndIf
		
	EndIf
		
	mvx=mvx/1.2
	mvy=mvy/1.2
	mvz=mvz/1.2
	
	MoveEntity player,mvx,0,mvz
	TranslateEntity player,0,mvy,0
	
	If EntityY(player)>60 Then PositionEntity player,EntityX(player),60,EntityZ(player)
	
End Function

