;Entorno
	HidePointer
	Graphics3D 640,480,16,2
	SetBuffer BackBuffer()
	AmbientLight 255,255,255

;tipos de modelos para las colicones y activacon de la misma
	tipo_hero=1
	tipo_piso=2
	Collisions 1,2,2,2
	
;carg modelos de escenario
	cielo=LoadMesh( "terreno\skybox2.x" )
	ScaleEntity cielo,5,5,5
	terreno=LoadMesh( "terreno\suelo.b3d" )
	EntityType terreno,tipo_piso
	Constr=LoadMesh( "const\torre1.b3d" )
	EntityType Constr,tipo_piso

;fuego donde sale el dwarf
	punto1=LoadAnimMesh( "const\point1.b3d" )
	Animate punto1,1,10
	EntityAlpha punto1,0.25
	MoveEntity punto1,-49,1.75,54
	
;carga al dwarf
	dwarf=LoadAnimMesh( "dwarf\dwarf2.b3d" )
	ScaleEntity dwarf,.125,.125,.125
	MoveEntity dwarf,-49.5,1.75,55
	TurnEntity dwarf,0,235,0
	EntityRadius dwarf,1
	EntityType dwarf,tipo_hero

;un punto atraz del dwarf
	pivodwarf=CreatePivot(dwarf)
	MoveEntity pivodwarf, 0,0,-60

;un punto al centro del dwarf
	pivodwarf1=CreatePivot(dwarf)
	MoveEntity pivodwarf1, 0,60,7
	
;camara en el punto detras del dwarf(pivodwarf) y a la altura de los hombros
	camera =CreateCamera()
	MoveEntity camera,0,11,-7
	EntityType camera,tipo_hero
	
;Secuecnias de animacion
	ExtractAnimSeq dwarf,2,14	   ;seq 1  camina
	ExtractAnimSeq dwarf,16,26	   ;seq 2  corre
	ExtractAnimSeq dwarf,327,360   ;seq 3 detenido
	
;seucencia por defecto 
	Animate dwarf,1,0.2,3

	
;velocidad por defecto
	velo#=0.15


; ************** BUCLE PRINCIPAL ***************
	While Not KeyHit(1)
	
	    ;mover al dwarf 
			moverdwarf(dwarf,velo#)
		    MoveEntity dwarf,0,-0.1,0
			                   
		;la camara sigue al dwarf
		    PointEntity camera,pivodwarf1
		  	dx#=EntityX( pivodwarf,True )-EntityX( camera )
			dz#=EntityZ( pivodwarf,True )-EntityZ( camera )
			TranslateEntity camera,dx# * .025,0,dz# * .025
	        	                     
	    ;gira el fuego
			girapunto(punto1)
		
		UpdateWorld
		RenderWorld
		Flip
	Wend
	
; ************************************************
	End

;fucnion que mueve el dwarf
Function moverdwarf(dwarf,velo#)
		If KeyDown( 200 )=True Or KeyDown( 208 )=True  Then 
		
			If KeyDown( 200 )=True And KeyDown(29)=False Then MoveEntity dwarf,0,0,velo#
			If KeyDown( 200 )=True And KeyDown(29)=True Then MoveEntity dwarf,0,0,velo# * 2
			If KeyDown( 208 )=True Then MoveEntity dwarf,0,0,-1*velo#
			
			If (AnimSeq(dwarf)=2 Or AnimSeq(dwarf)=3)  And KeyDown(29)=False Then
				Animate dwarf,1,0.3,1 
			EndIf

			If (AnimSeq(dwarf)=1 Or AnimSeq(dwarf)=3)  And KeyDown(29)=True Then
				Animate dwarf,1,0.3,2 
			EndIf
		Else
			If AnimSeq(dwarf)=1 Or AnimSeq(dwarf)=2 Then
				Animate dwarf,1,0.5,3 
			EndIf
		EndIf
		
		If KeyDown( 203 )=True Then TurnEntity dwarf,0,1.5,0
		If KeyDown( 205 )=True Then TurnEntity dwarf,0,-1.5,0
End Function

Function girapunto(punto)
	TurnEntity punto,0,0.5,0
End Function